/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.stamina.network;

import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.stamina.network.NetworkHandler;
import insane96mcp.stamina.network.NetworkHelper;
import insane96mcp.stamina.stamina.StaminaFeature;
import insane96mcp.stamina.stamina.StaminaHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class StaminaSync {
    float stamina;
    boolean staminaLocked;

    public StaminaSync(float stamina, boolean staminaLocked) {
        this.stamina = stamina;
        this.staminaLocked = staminaLocked;
    }

    public static void encode(StaminaSync pkt, FriendlyByteBuf buf) {
        buf.writeFloat(pkt.stamina);
        buf.writeBoolean(pkt.staminaLocked);
    }

    public static StaminaSync decode(FriendlyByteBuf buf) {
        return new StaminaSync(buf.readFloat(), buf.readBoolean());
    }

    public static void handle(StaminaSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = NetworkHelper.getSidedPlayer((NetworkEvent.Context)ctx.get());
            ModNBTData.put((Entity)player, (ResourceLocation)StaminaFeature.STAMINA, (Object)Float.valueOf(message.stamina));
            ModNBTData.put((Entity)player, (ResourceLocation)StaminaFeature.STAMINA_LOCKED, (Object)message.staminaLocked);
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sync(ServerPlayer player) {
        StaminaSync msg = new StaminaSync(StaminaHandler.getStamina((Player)player), StaminaHandler.isStaminaLocked((Player)player));
        NetworkHandler.CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

