/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.stamina.stamina;

import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.stamina.stamina.IStaminaModifier;
import insane96mcp.stamina.stamina.StaminaFeature;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class StaminaHandler {
    public static float getMaxPossibleStamina(Player player) {
        int enchLvl;
        float maxPossibleStamina = Mth.m_14167_((float)player.m_21233_()) * StaminaFeature.stamina$perHalfHeart;
        if (player.m_21051_((Attribute)StaminaFeature.BONUS_STAMINA_ATTRIBUTE.get()) != null) {
            maxPossibleStamina += (float)player.m_21133_((Attribute)StaminaFeature.BONUS_STAMINA_ATTRIBUTE.get());
        }
        if (StaminaFeature.stamina$bonusPerLevelOfVigourEnchantment > 0 && (enchLvl = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)StaminaFeature.VIGOUR.get()), (LivingEntity)player)) > 0) {
            maxPossibleStamina += (float)(StaminaFeature.stamina$bonusPerLevelOfVigourEnchantment * enchLvl);
        }
        for (MobEffectInstance instance : player.m_21220_()) {
            MobEffect mobEffect = instance.m_19544_();
            if (!(mobEffect instanceof IStaminaModifier)) continue;
            IStaminaModifier staminaModifier = (IStaminaModifier)mobEffect;
            maxPossibleStamina += (float)staminaModifier.bonusMaxStamina(instance.m_19564_());
        }
        double armor = player.m_21133_(Attributes.f_22284_);
        return maxPossibleStamina *= (float)(1.0 - armor * StaminaFeature.stamina$percentageReductionPerArmorPoint);
    }

    public static float getMaxStamina(Player player) {
        if (StaminaFeature.stamina$boundToMaxHealth.booleanValue()) {
            return StaminaHandler.getMaxPossibleStamina(player);
        }
        float ratio = player.m_21223_() / player.m_21233_();
        return StaminaHandler.getMaxPossibleStamina(player) * ratio;
    }

    public static float getMaxStamina(Player player, float maxPossibleStamina) {
        if (StaminaFeature.stamina$boundToMaxHealth.booleanValue()) {
            return maxPossibleStamina;
        }
        float ratio = player.m_21223_() / player.m_21233_();
        return maxPossibleStamina * ratio;
    }

    public static float getStamina(Player player) {
        return ((Float)ModNBTData.get((Entity)player, (ResourceLocation)StaminaFeature.STAMINA, Float.class)).floatValue();
    }

    public static boolean isStaminaLocked(Player player) {
        return (Boolean)ModNBTData.get((Entity)player, (ResourceLocation)StaminaFeature.STAMINA_LOCKED, Boolean.class);
    }

    public static boolean canSprint(Player player) {
        return !StaminaHandler.isStaminaLocked(player) || StaminaFeature.canConsumeHunger(player);
    }

    public static float setStamina(Player player, float stamina) {
        stamina = Mth.m_14036_((float)stamina, (float)0.0f, (float)StaminaHandler.getMaxStamina(player));
        ModNBTData.put((Entity)player, (ResourceLocation)StaminaFeature.STAMINA, (Object)Float.valueOf(stamina));
        return stamina;
    }

    public static void consumeStamina(Player player, float amount) {
        float staminaSetTo = StaminaHandler.setStamina(player, StaminaHandler.getStamina(player) - amount);
        if (staminaSetTo <= 0.0f) {
            StaminaHandler.lockSprinting(player);
        }
        if (StaminaFeature.canConsumeHunger(player) && StaminaHandler.isStaminaLocked(player)) {
            player.m_36324_().m_38703_(StaminaFeature.lock$consumeHungerRatio.floatValue() * amount);
        }
    }

    public static float regenStamina(Player player, float amount) {
        return StaminaHandler.setStamina(player, StaminaHandler.getStamina(player) + amount);
    }

    public static void lockSprinting(Player player) {
        ModNBTData.put((Entity)player, (ResourceLocation)StaminaFeature.STAMINA_LOCKED, (Object)true);
    }

    public static void unlockSprinting(Player player) {
        ModNBTData.put((Entity)player, (ResourceLocation)StaminaFeature.STAMINA_LOCKED, (Object)false);
    }
}

