/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.stamina.stamina;

import com.mojang.blaze3d.systems.RenderSystem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.event.PlayerSprintEvent;
import insane96mcp.insanelib.util.ClientUtils;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.stamina.Stamina;
import insane96mcp.stamina.effect.VigourEffect;
import insane96mcp.stamina.enchantment.VigourEnchantment;
import insane96mcp.stamina.event.SEventFactory;
import insane96mcp.stamina.mixin.GuiAccessor;
import insane96mcp.stamina.network.StaminaSync;
import insane96mcp.stamina.setup.SRegistries;
import insane96mcp.stamina.stamina.IStaminaModifier;
import insane96mcp.stamina.stamina.StaminaHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="stamina:base", canBeDisabled=false, description="Stamina to let the player run and do stuff.")
public class StaminaFeature
extends Feature {
    public static final RegistryObject<MobEffect> VIGOUR_EFFECT = SRegistries.MOB_EFFECTS.register("vigour", () -> new VigourEffect(MobEffectCategory.BENEFICIAL, 16569203));
    public static final ResourceLocation HEART_OVERLAY = Stamina.location("textures/gui/heart_overlay.png");
    public static final ResourceLocation LOCKED_HEART_OVERLAY = Stamina.location("textures/gui/locked_heart_overlay.png");
    public static final UUID LOCK_SLOWDOWN_UUID = UUID.fromString("b17cbf02-97f8-4c50-9cd1-6dc732593fed");
    public static final UUID SPRINT_SLOWDOWN_UUID = UUID.fromString("d5c66a92-3f1f-44a2-95a6-1a9e66c6d8e5");
    public static final ResourceLocation STAMINA = Stamina.location("stamina");
    public static final ResourceLocation STAMINA_LOCKED = Stamina.location("stamina_locked");
    public static final ResourceLocation LAST_HIT = Stamina.location("last_hit");
    public static final ResourceLocation LAST_HURT = Stamina.location("last_hurt");
    public static String OVERLAY = "stamina_overlay";
    public static final RegistryObject<Enchantment> VIGOUR = SRegistries.ENCHANTMENTS.register("vigour", VigourEnchantment::new);
    public static final RegistryObject<Attribute> BONUS_STAMINA_ATTRIBUTE = SRegistries.ATTRIBUTES.register("bonus_stamina", () -> new RangedAttribute("attribute.name.bonus_stamina", 0.0, -1.7976931348623157E308, Double.MAX_VALUE).m_22084_(true));
    @Config(min=0.0, description="How much stamina the player has per half heart. Each 1 stamina is 1 tick of running")
    public static Integer stamina$perHalfHeart = 10;
    @Config(min=0.0)
    public static Integer stamina$bonusPerLevelOfVigourEnchantment = 40;
    @Config(min=0.0)
    public static Integer stamina$bonusPerLevelOfVigourEffect = 40;
    @Config(min=0.0)
    public static Double stamina$percentageReductionPerArmorPoint = 0.025;
    @Config(description="If enabled, max stamina will always be bound to max health and no longer with current health")
    public static Boolean stamina$boundToMaxHealth = false;
    @Config(min=0.0, description="How much stamina the player consumes each tick when sprinting")
    public static Double consumption$sprint = 1.0;
    @Config(min=0.0, description="How much stamina the player consumes on each jump")
    public static Integer consumption$jump = 10;
    @Config(min=0.0, description="How much stamina the player consumes each tick when swimming")
    public static Double consumption$swim = 0.5;
    @Config(min=0.0, description="Multiplier for stamina consumed when the player is swimming with the conduit power effect.")
    public static Double consumption$conduitSwimmingModifier = 0.85;
    @Config(min=0.0, description="How much stamina the player consumes each tick when mining. If stamina is locked, mining speed is halved")
    public static Double consumption$mine = 0.0;
    @Config(min=0.0, description="Stamina consumption will be multiplied by this value when the player is out of combat. Out of combat = not attacked or hurt in the last 15 seconds")
    public static Double consumption$outOfCombatMultiplier = 0.8;
    @Config(min=0.0)
    public static Double regen$perTick = 2.0;
    @Config(min=0.0, description="Multiplier for the regen per tick when stamina is locked")
    public static Double regen$modifierWhenLocked = 0.6;
    @Config(min=0.0, description="Multiplier for the regen per tick when player's in water")
    public static Double regen$modifierWhenInWater = 1.0;
    @Config(min=0.0, description="'Modified when in water' is applied only when the player is not on the ground")
    public static Boolean regen$modifierWhenInWaterWhenOffGround = true;
    @Config(min=0.0, description="Percentage reduction per armor point")
    public static Double regen$reductionPerArmorPoint = 0.025;
    @Config(min=0.0, max=1.0, description="When max stamina goes below this percentage, stamina will be locked. With locked stamina, the player can't sprint")
    public static Double lock$belowHealthRatio = 0.2;
    @Config(min=0.0, max=1.0, description="At which health percentage will stamina be unlocked")
    public static Double lock$unlockAtHealthRatio = 0.4;
    @Config(min=0.0, description="If this > 0, the player will still be able to sprint when stamina is locked, at the cost of a great amount of hunger. Stamina consumed will be applied to exhaustion at this rate. By default consumed 1 hunger/saturation per second of sprinting")
    public static Double lock$consumeHungerRatio = 0.1;
    @Config(min=0.0, max=1.0, description="Below this percentage stamina, sprinting will be less effective.")
    public static Double slowdown$sprinting$threshold = 0.2;
    @Config(description="Below this stamina amount, sprinting will be less effective.")
    public static Double slowdown$sprinting$thresholdFlat = 40.0;
    @Config(min=0.0, max=1.0, description="Slowdown sprinting and swimming by this amount, vanilla sprint is x1.3")
    public static Double slowdown$sprinting$amount = 0.15;
    @Config(description="If stamina is locked, player will be slowed down.")
    public static Boolean slowdown$whenLocked$enabled = true;
    @Config(min=0.0, max=1.0)
    public static Double slowdown$whenLocked$amount = 0.1;
    @Config(description="Disable sprinting altogether")
    public static Boolean disable$sprinting = false;
    @Config(description="Disable swimming altogether")
    public static Boolean disable$swimming = false;
    private static final Map<ServerPlayer, Integer> tickMined = new HashMap<ServerPlayer, Integer>();
    private static final Vec2 UV_STAMINA = new Vec2(0.0f, 9.0f);

    @SubscribeEvent
    public static void addAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)BONUS_STAMINA_ATTRIBUTE.get())) continue;
            event.add(entityType, (Attribute)BONUS_STAMINA_ATTRIBUTE.get());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        block21: {
            block20: {
                Player player2 = event.player;
                if (!(player2 instanceof ServerPlayer)) break block20;
                player = (ServerPlayer)player2;
                if (!event.phase.equals((Object)TickEvent.Phase.START) && (!disable$sprinting.booleanValue() || !disable$swimming.booleanValue())) break block21;
            }
            return;
        }
        boolean shouldSync = false;
        float maxPossibleStamina = StaminaHandler.getMaxPossibleStamina((Player)player);
        float maxStamina = StaminaHandler.getMaxStamina((Player)player, maxPossibleStamina);
        float stamina = StaminaHandler.getStamina((Player)player);
        float maxStaminaPercentage = maxStamina / maxPossibleStamina;
        float staminaPercentage = stamina / maxStamina;
        boolean isStaminaLocked = StaminaHandler.isStaminaLocked((Player)player);
        if (player.f_19797_ == 1) {
            shouldSync = true;
        }
        if (player.m_20142_() && player.m_20202_() == null && !player.m_7500_() && !player.m_5833_()) {
            float staminaToConsume = consumption$sprint.floatValue();
            if (player.m_20089_() == Pose.SWIMMING) {
                staminaToConsume = consumption$swim.floatValue();
            }
            float percIncrease = 0.0f;
            for (MobEffectInstance instance : player.m_21220_()) {
                MobEffect mobEffect = instance.m_19544_();
                if (!(mobEffect instanceof IStaminaModifier)) continue;
                IStaminaModifier staminaModifier = (IStaminaModifier)mobEffect;
                percIncrease += staminaModifier.consumedStaminaModifier(instance.m_19564_());
            }
            staminaToConsume += staminaToConsume * percIncrease;
            if (player.m_20089_() == Pose.SWIMMING && player.m_21023_(MobEffects.f_19592_)) {
                staminaToConsume *= consumption$conduitSwimmingModifier.floatValue();
            }
            staminaToConsume = SEventFactory.onStaminaConsumed((Player)player, staminaToConsume);
            if (!StaminaFeature.isInCombat(player)) {
                staminaToConsume *= consumption$outOfCombatMultiplier.floatValue();
            }
            if (staminaToConsume == 0.0f) {
                return;
            }
            StaminaHandler.consumeStamina((Player)player, staminaToConsume);
            shouldSync = true;
        } else if (!StaminaFeature.isMining(player) && stamina != maxStamina && (double)maxStaminaPercentage >= lock$belowHealthRatio) {
            float staminaToRecover = regen$perTick.floatValue();
            if (isStaminaLocked) {
                staminaToRecover *= regen$modifierWhenLocked.floatValue();
            }
            if (!(!player.m_20069_() || player.m_20096_() && regen$modifierWhenInWaterWhenOffGround.booleanValue() || regen$modifierWhenInWater == 1.0)) {
                staminaToRecover *= regen$modifierWhenInWater.floatValue();
            }
            float percIncrease = 0.0f;
            for (MobEffectInstance instance : player.m_21220_()) {
                MobEffect mobEffect = instance.m_19544_();
                if (!(mobEffect instanceof IStaminaModifier)) continue;
                IStaminaModifier staminaModifier = (IStaminaModifier)mobEffect;
                percIncrease += staminaModifier.regenStaminaModifier(instance.m_19564_());
            }
            staminaToRecover += staminaToRecover * percIncrease;
            double armor = player.m_21133_(Attributes.f_22284_);
            staminaToRecover *= (float)(1.0 - armor * regen$reductionPerArmorPoint);
            if ((staminaToRecover = SEventFactory.onStaminaRegenerated((Player)player, staminaToRecover)) == 0.0f) {
                return;
            }
            stamina = StaminaHandler.regenStamina((Player)player, staminaToRecover);
            if (isStaminaLocked && (double)staminaPercentage >= lock$unlockAtHealthRatio) {
                StaminaHandler.unlockSprinting((Player)player);
                isStaminaLocked = false;
            }
            shouldSync = true;
        } else if (!isStaminaLocked && (double)maxStaminaPercentage < lock$belowHealthRatio) {
            StaminaHandler.setStamina((Player)player, 0.0f);
            StaminaHandler.lockSprinting((Player)player);
            isStaminaLocked = true;
            shouldSync = true;
        }
        StaminaFeature.slowdown((Player)player, maxStaminaPercentage, staminaPercentage, stamina, isStaminaLocked);
        if (StaminaFeature.isMining(player) || shouldSync) {
            StaminaSync.sync(player);
        }
    }

    public static void slowdown(Player player, float maxStaminaPercentage, float staminaPercentage, float stamina, boolean isLocked) {
        StaminaFeature.slowdownLocked(player, isLocked);
        StaminaFeature.slowdownSprinting(player, staminaPercentage, stamina);
    }

    private static void slowdownLocked(Player player, boolean isLocked) {
        player.m_21051_(Attributes.f_22279_).m_22120_(LOCK_SLOWDOWN_UUID);
        if (!isLocked || !slowdown$whenLocked$enabled.booleanValue()) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)player, (Attribute)Attributes.f_22279_, (UUID)LOCK_SLOWDOWN_UUID, (String)"Stamina locked slowdown", (double)(-slowdown$whenLocked$amount.doubleValue()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
        MCUtils.applyModifier((LivingEntity)player, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)LOCK_SLOWDOWN_UUID, (String)"Stamina locked slowdown", (double)(-slowdown$whenLocked$amount.doubleValue()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
    }

    private static void slowdownSprinting(Player player, float staminaPercentage, float stamina) {
        player.m_21051_(Attributes.f_22279_).m_22120_(SPRINT_SLOWDOWN_UUID);
        if (!player.m_20142_() || (double)stamina >= slowdown$sprinting$thresholdFlat && (double)staminaPercentage >= slowdown$sprinting$threshold) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)player, (Attribute)Attributes.f_22279_, (UUID)LOCK_SLOWDOWN_UUID, (String)"Stamina sprinting slowdown", (double)(-slowdown$sprinting$amount.doubleValue()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
        MCUtils.applyModifier((LivingEntity)player, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)LOCK_SLOWDOWN_UUID, (String)"Stamina swimming slowdown", (double)(-slowdown$sprinting$amount.doubleValue()), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (consumption$mine == 0.0) {
            return;
        }
        Player player = event.getEntity();
        if (StaminaHandler.isStaminaLocked(player)) {
            event.setNewSpeed(event.getNewSpeed() * 0.5f);
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (StaminaHandler.getStamina(player) > 0.0f) {
                StaminaHandler.consumeStamina(player, consumption$mine.floatValue());
                tickMined.put(serverPlayer, player.f_19797_);
            }
        }
    }

    public static boolean isMining(ServerPlayer player) {
        return Feature.isEnabled(StaminaFeature.class) && tickMined.containsKey(player) && player.f_19797_ < tickMined.get(player) + 8;
    }

    public static boolean isInCombat(ServerPlayer player) {
        return player.m_9236_().m_46467_() - (long)((Integer)ModNBTData.get((Entity)player, (ResourceLocation)LAST_HIT, Integer.class)).intValue() < 300L || player.m_9236_().m_46467_() - (long)((Integer)ModNBTData.get((Entity)player, (ResourceLocation)LAST_HURT, Integer.class)).intValue() < 300L;
    }

    @SubscribeEvent
    public void onAttack(LivingDamageEvent event) {
        if (consumption$outOfCombatMultiplier == 1.0) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            ModNBTData.put((Entity)serverPlayer, (ResourceLocation)LAST_HURT, (Object)serverPlayer.m_9236_().m_46467_());
        } else {
            livingEntity = event.getSource().m_7639_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ModNBTData.put((Entity)serverPlayer, (ResourceLocation)LAST_HIT, (Object)serverPlayer.m_9236_().m_46467_());
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        tickMined.remove(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onSprint(PlayerSprintEvent event) {
        if (!this.isEnabled() || event.getPlayer().m_150110_().f_35937_) {
            return;
        }
        if (!StaminaHandler.canSprint((Player)event.getPlayer()) || disable$sprinting.booleanValue() && !event.getPlayer().canStartSwimming() || disable$swimming.booleanValue() && event.getPlayer().canStartSwimming()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || consumption$jump == 0 || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        float consumed = consumption$jump.intValue();
        float percIncrease = 0.0f;
        for (MobEffectInstance instance : player.m_21220_()) {
            MobEffect mobEffect = instance.m_19544_();
            if (!(mobEffect instanceof IStaminaModifier)) continue;
            IStaminaModifier staminaModifier = (IStaminaModifier)mobEffect;
            percIncrease += staminaModifier.consumedStaminaModifier(instance.m_19564_());
        }
        consumed += consumed * percIncrease;
        StaminaHandler.consumeStamina((Player)player, consumed);
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        StaminaSync.sync(player2);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        StaminaHandler.setStamina(event.getEntity(), Float.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderGuiOverlayPre(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), OVERLAY, (gui, guiGraphics, partialTicks, screenWidth, screenHeight) -> {
            if (StaminaFeature.isEnabled(StaminaFeature.class) && gui.shouldDrawSurvivalElements()) {
                StaminaFeature.renderStamina(gui, guiGraphics);
            }
        });
    }

    public static boolean canConsumeHunger(Player player) {
        return lock$consumeHungerRatio > 0.0 && player.m_36324_().m_38702_() > 0 && !ModList.get().isLoaded("nohunger");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderStamina(ForgeGui gui, GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        ((GuiAccessor)gui).getRandom().m_188584_((long)gui.m_93079_() * 312871L);
        boolean shouldRenderOnOneRow = ModList.get().isLoaded("mantle");
        int health = Mth.m_14167_((float)player.m_21223_());
        if (stamina$boundToMaxHealth.booleanValue()) {
            health = Mth.m_14167_((float)player.m_21233_());
        }
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = Math.max((float)attrMaxHealth.m_22135_(), (float)health);
        int healthMaxI = Mth.m_14167_((float)healthMax);
        int absorp = Mth.m_14167_((float)player.m_6103_());
        int halfAbsorp = Mth.m_14167_((float)(player.m_6103_() / 2.0f));
        int healthRows = Mth.m_14167_((float)((healthMax + (float)absorp) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int leftHeight = gui.leftHeight;
        if (!shouldRenderOnOneRow) {
            leftHeight -= healthRows * rowHeight;
            if (rowHeight != 10) {
                leftHeight -= 10 - rowHeight;
            }
        } else {
            leftHeight -= 10;
        }
        if (absorp > 0) {
            leftHeight = shouldRenderOnOneRow ? (leftHeight -= 10) : (leftHeight -= Mth.m_14167_((float)((float)absorp / 20.0f)));
        }
        int right = mc.m_91268_().m_85445_() / 2 - 91;
        int top = mc.m_91268_().m_85446_() - leftHeight;
        float staminaPerHalfHeart = StaminaHandler.getMaxStamina((Player)player) / (float)health;
        if (shouldRenderOnOneRow) {
            staminaPerHalfHeart = StaminaHandler.getMaxStamina((Player)player) / Math.min((float)health, 20.0f);
        }
        int halfHeartsMaxStamina = Mth.m_14167_((float)(StaminaHandler.getMaxStamina((Player)player) / staminaPerHalfHeart));
        int halfHeartsStamina = Mth.m_14167_((float)(StaminaHandler.getStamina((Player)player) / staminaPerHalfHeart));
        int height = 9;
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = gui.m_93079_() % Mth.m_14167_((float)(healthMax + 5.0f));
        }
        ResourceLocation texture = HEART_OVERLAY;
        if (StaminaHandler.isStaminaLocked((Player)player)) {
            texture = LOCKED_HEART_OVERLAY;
        }
        int oldJiggle = 0;
        for (int a = 0; a < halfAbsorp; ++a) {
            ((GuiAccessor)gui).getRandom().m_188503_(2);
        }
        for (int hp = healthMaxI - 1; hp >= 0; --hp) {
            int r;
            int u;
            int width;
            int jiggle = 0;
            if ((hp + 1) % 2 == 0) {
                if (hp / 2 == regen) {
                    jiggle -= 2;
                }
                if (health + absorp <= 4) {
                    jiggle += ((GuiAccessor)gui).getRandom().m_188503_(2);
                }
                oldJiggle = jiggle;
            } else {
                jiggle = oldJiggle;
            }
            if (hp >= halfHeartsMaxStamina || hp < halfHeartsStamina) continue;
            int v = (int)StaminaFeature.UV_STAMINA.f_82471_;
            if (hp % 2 == 0) {
                width = 4;
                u = (int)StaminaFeature.UV_STAMINA.f_82470_ + 1;
                r = 1;
            } else {
                width = 4;
                u = (int)StaminaFeature.UV_STAMINA.f_82470_ + 5;
                r = 5;
            }
            int pY = top - hp / 20 * rowHeight + jiggle;
            if (shouldRenderOnOneRow) {
                pY = top + jiggle;
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280163_(texture, right + hp / 2 * 8 + r - hp / 20 * 80, pY, (float)u, (float)v, width, height, 9, 9);
            RenderSystem.disableBlend();
        }
        ClientUtils.resetRenderColor();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void debugScreen(CustomizeGuiOverlayEvent.DebugText event) {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer playerEntity = mc.f_91074_;
        if (playerEntity == null) {
            return;
        }
        if (mc.f_91066_.f_92063_ && !mc.m_91299_()) {
            event.getLeft().add(String.format("Stamina: %.1f/%.1f; Locked: %s", Float.valueOf(StaminaHandler.getStamina((Player)playerEntity)), Float.valueOf(StaminaHandler.getMaxStamina((Player)playerEntity)), StaminaHandler.isStaminaLocked((Player)playerEntity)));
        }
    }
}

