/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.common.ComfortsEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;

public class ComfortsCommonEventsListener {
    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        if (!ComfortsEvents.canSetSpawn(evt.getEntity(), evt.getNewSpawn())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSleepTimeCheck(CanContinueSleepingEvent evt) {
        evt.getEntity().getSleepingPos().ifPresent(sleepingPos -> {
            ComfortsEvents.Result result = ComfortsEvents.checkTime(evt.getEntity().level(), sleepingPos);
            Player.BedSleepingProblem problem = evt.getProblem();
            if (result == ComfortsEvents.Result.ALLOW && problem == Player.BedSleepingProblem.NOT_POSSIBLE_NOW) {
                evt.setContinueSleeping(true);
            }
            if (result == ComfortsEvents.Result.DENY) {
                evt.setContinueSleeping(false);
            }
        });
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            long time;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            long newTime = evt.getNewTime();
            if (newTime != (time = ComfortsEvents.getWakeTime(serverLevel, serverLevel.getDayTime(), newTime))) {
                evt.setTimeAddition(time);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        ComfortsEvents.onWakeUp(evt.getEntity());
    }

    @SubscribeEvent
    public void onPlayerSleep(CanPlayerSleepEvent evt) {
        Player.BedSleepingProblem sleepingProblem;
        ComfortsEvents.Result result = ComfortsEvents.checkTime((Level)evt.getEntity().level(), evt.getPos());
        Player.BedSleepingProblem problem = evt.getVanillaProblem();
        if (result == ComfortsEvents.Result.ALLOW && problem == Player.BedSleepingProblem.NOT_POSSIBLE_NOW && evt.getProblem() == problem) {
            evt.setProblem(null);
        } else if (result == ComfortsEvents.Result.DENY) {
            evt.setProblem(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        } else if (evt.getProblem() == null && (sleepingProblem = ComfortsEvents.onSleep((Player)evt.getEntity())) != null) {
            evt.setProblem(sleepingProblem);
        }
    }
}

