/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.network;

import com.illusivesoulworks.comforts.common.item.SleepingBagItem;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3f;

public record SPacketPlaceBag(int entityId, InteractionHand hand, Direction direction, BlockPos blockPos, Vector3f location, boolean inside) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SPacketPlaceBag> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"place_bag"));
    public static final StreamCodec<FriendlyByteBuf, SPacketPlaceBag> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SPacketPlaceBag::entityId, (StreamCodec)ByteBufCodecs.idMapper(val -> InteractionHand.values()[val], Enum::ordinal), SPacketPlaceBag::hand, (StreamCodec)ByteBufCodecs.idMapper(val -> Direction.values()[val], Enum::ordinal), SPacketPlaceBag::direction, (StreamCodec)BlockPos.STREAM_CODEC, SPacketPlaceBag::blockPos, (StreamCodec)ByteBufCodecs.VECTOR3F, SPacketPlaceBag::location, (StreamCodec)ByteBufCodecs.BOOL, SPacketPlaceBag::inside, SPacketPlaceBag::new);

    public static void handle(Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        Item item = player.getItemInHand(hand).getItem();
        if (item instanceof SleepingBagItem) {
            SleepingBagItem sleepingBagItem = (SleepingBagItem)item;
            sleepingBagItem.syncedUseOn(new UseOnContext(player, hand, blockHitResult));
        }
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

