/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.data;

import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import com.illusivesoulworks.comforts.data.HammockEnabledCondition;
import com.illusivesoulworks.comforts.data.SleepingBagEnabledCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class ComfortsRecipeProvider
extends RecipeProvider {
    public ComfortsRecipeProvider(HolderLookup.Provider pRegistries, RecipeOutput recipeOutput) {
        super(pRegistries, recipeOutput);
    }

    protected void buildRecipes() {
        List<TagKey<Item>> dyes = List.of(Tags.Items.DYES_WHITE, Tags.Items.DYES_ORANGE, Tags.Items.DYES_MAGENTA, Tags.Items.DYES_LIGHT_BLUE, Tags.Items.DYES_YELLOW, Tags.Items.DYES_LIME, Tags.Items.DYES_PINK, Tags.Items.DYES_GRAY, Tags.Items.DYES_LIGHT_GRAY, Tags.Items.DYES_CYAN, Tags.Items.DYES_PURPLE, Tags.Items.DYES_BLUE, Tags.Items.DYES_BROWN, Tags.Items.DYES_GREEN, Tags.Items.DYES_RED, Tags.Items.DYES_BLACK);
        List<Item> hammocks = ComfortsRegistry.HAMMOCKS.values().stream().map(blockRegistryObject -> ((Block)blockRegistryObject.get()).asItem()).toList();
        List<Item> sleepingBags = ComfortsRegistry.SLEEPING_BAGS.values().stream().map(blockRegistryObject -> ((Block)blockRegistryObject.get()).asItem()).toList();
        List<Item> wool = List.of(Items.WHITE_WOOL, Items.ORANGE_WOOL, Items.MAGENTA_WOOL, Items.LIGHT_BLUE_WOOL, Items.YELLOW_WOOL, Items.LIME_WOOL, Items.PINK_WOOL, Items.GRAY_WOOL, Items.LIGHT_GRAY_WOOL, Items.CYAN_WOOL, Items.PURPLE_WOOL, Items.BLUE_WOOL, Items.BROWN_WOOL, Items.GREEN_WOOL, Items.RED_WOOL, Items.BLACK_WOOL);
        for (int i = 0; i < wool.size(); ++i) {
            this.sleepingBag(this.output, (ItemLike)sleepingBags.get(i), (ItemLike)wool.get(i));
            this.hammock(this.output, (ItemLike)hammocks.get(i), (ItemLike)wool.get(i));
        }
        this.colorWithDye(this.output.withConditions(new ICondition[]{HammockEnabledCondition.INSTANCE}), dyes, hammocks, "comforts:hammock");
        this.colorWithDye(this.output.withConditions(new ICondition[]{SleepingBagEnabledCondition.INSTANCE}), dyes, sleepingBags, "comforts:sleeping_bag");
        Item ropeAndNail = ComfortsRegistry.ROPE_AND_NAIL_ITEM.get();
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)ropeAndNail, 2).define(Character.valueOf('A'), Tags.Items.STRINGS).define(Character.valueOf('X'), Tags.Items.INGOTS_IRON).pattern("AA ").pattern("AX ").pattern("  A").group("comforts:rope_and_nail").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(this.output.withConditions(new ICondition[]{HammockEnabledCondition.INSTANCE}));
        ArrayList<HammockEnabledCondition> conditions = new ArrayList<HammockEnabledCondition>();
        conditions.add(HammockEnabledCondition.INSTANCE);
        conditions.add((HammockEnabledCondition)new NotCondition((ICondition)new TagEmptyCondition(Tags.Items.ROPES)));
        this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)ropeAndNail, 2).requires(Tags.Items.INGOTS_IRON).requires(Tags.Items.ROPES).group("comforts:rope_and_nail").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(this.output.withConditions(new ICondition[]{new AndCondition(conditions)}), "comforts:shapeless_" + ComfortsRecipeProvider.getItemName((ItemLike)ropeAndNail));
    }

    protected void colorWithDye(RecipeOutput pRecipeOutput, List<TagKey<Item>> pDyes, List<Item> pDyeableItems, String pGroup) {
        for (int i = 0; i < pDyes.size(); ++i) {
            TagKey<Item> dye = pDyes.get(i);
            Item item = pDyeableItems.get(i);
            this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).requires(dye).requires(Ingredient.of(pDyeableItems.stream().filter(val -> !val.equals(item)))).group(pGroup).unlockedBy("has_needed_dye", this.has(dye)).save(pRecipeOutput, "comforts:dye_" + ComfortsRecipeProvider.getItemName((ItemLike)item));
        }
    }

    protected void sleepingBag(RecipeOutput pRecipeOutput, ItemLike pBed, ItemLike pWool) {
        this.shaped(RecipeCategory.DECORATIONS, pBed).define(Character.valueOf('#'), pWool).pattern(" # ").pattern(" # ").pattern(" # ").group("comforts:sleeping_bag").unlockedBy(ComfortsRecipeProvider.getHasName((ItemLike)pWool), this.has(pWool)).save(pRecipeOutput.withConditions(new ICondition[]{SleepingBagEnabledCondition.INSTANCE}));
    }

    protected void hammock(RecipeOutput pRecipeOutput, ItemLike pBed, ItemLike pWool) {
        this.shaped(RecipeCategory.DECORATIONS, pBed).define(Character.valueOf('#'), pWool).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).pattern(" X ").pattern("S#S").pattern(" X ").group("comforts:hammock").unlockedBy(ComfortsRecipeProvider.getHasName((ItemLike)pWool), this.has(pWool)).save(pRecipeOutput.withConditions(new ICondition[]{HammockEnabledCondition.INSTANCE}));
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        @Nonnull
        protected RecipeProvider createRecipeProvider(@Nonnull HolderLookup.Provider lookupProvider, @Nonnull RecipeOutput output) {
            return new ComfortsRecipeProvider(lookupProvider, output);
        }

        @Nonnull
        public String getName() {
            return "Comforts recipes";
        }
    }
}

