/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts;

import com.illusivesoulworks.comforts.ComfortsCommonMod;
import com.illusivesoulworks.comforts.common.CapabilitySleepData;
import com.illusivesoulworks.comforts.common.ComfortsCommonEventsListener;
import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import com.illusivesoulworks.comforts.common.capability.ISleepData;
import com.illusivesoulworks.comforts.common.network.ComfortsForgeNetwork;
import com.illusivesoulworks.comforts.common.registry.RegistryObject;
import com.illusivesoulworks.comforts.data.ComfortsRecipeProvider;
import com.illusivesoulworks.comforts.data.HammockEnabledCondition;
import com.illusivesoulworks.comforts.data.SleepingBagEnabledCondition;
import com.mojang.serialization.MapCodec;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="comforts")
public class ComfortsForgeMod {
    private static final DeferredRegister<MapCodec<? extends ICondition>> CONDITIONS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.CONDITION_SERIALIZERS, (String)"comforts");
    public static final Supplier<MapCodec<? extends ICondition>> SLEEPING_BAG_CONDITION = CONDITIONS.register("sleeping_bag_enabled", () -> SleepingBagEnabledCondition.CODEC);
    public static final Supplier<MapCodec<? extends ICondition>> HAMMOCK_CONDITION = CONDITIONS.register("hammock_enabled", () -> HammockEnabledCondition.CODEC);

    public ComfortsForgeMod(FMLJavaModLoadingContext context) {
        ComfortsCommonMod.init();
        ComfortsCommonMod.initConfig();
        BusGroup busGroup = context.getModBusGroup();
        CONDITIONS.register(busGroup);
        FMLCommonSetupEvent.getBus((BusGroup)busGroup).addListener(this::setup);
        RegisterCapabilitiesEvent.getBus((BusGroup)busGroup).addListener(this::registerCapabilities);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)busGroup).addListener(this::creativeTab);
        GatherDataEvent.getBus((BusGroup)busGroup).addListener(this::gatherData);
    }

    private void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        if (evt.includeServer()) {
            CompletableFuture lookupProvider = evt.getLookupProvider();
            DataGenerator gen = evt.getGenerator();
            PackOutput packOutput = gen.getPackOutput();
            generator.addProvider(true, (DataProvider)new ComfortsRecipeProvider.Runner(packOutput, lookupProvider));
        }
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ComfortsCommonEventsListener());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilitySleepData.CapabilityEvents());
        ComfortsForgeNetwork.setup();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.register(ISleepData.class);
    }

    private void creativeTab(BuildCreativeModeTabContentsEvent evt) {
        ResourceKey tab = evt.getTabKey();
        if (tab == CreativeModeTabs.COLORED_BLOCKS || tab == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            for (RegistryObject<Block> value : ComfortsRegistry.SLEEPING_BAGS.values()) {
                evt.accept(value);
            }
            for (RegistryObject<Block> value : ComfortsRegistry.HAMMOCKS.values()) {
                evt.accept(value);
            }
        }
        if (tab == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            evt.accept(ComfortsRegistry.ROPE_AND_NAIL_ITEM);
        }
    }
}

