/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.client.renderer;

import com.illusivesoulworks.comforts.common.block.entity.BaseComfortsBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.state.BedRenderState;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public abstract class BaseComfortsBlockEntityRenderer<T extends BaseComfortsBlockEntity>
implements BlockEntityRenderer<T, BedRenderState> {
    public static final ModelLayerLocation SLEEPING_BAG_HEAD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"sleeping_bag_head"), "main");
    public static final ModelLayerLocation SLEEPING_BAG_FOOT = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"sleeping_bag_foot"), "main");
    public static final ModelLayerLocation HAMMOCK_HEAD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"hammock_head"), "main");
    public static final ModelLayerLocation HAMMOCK_FOOT = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"hammock_foot"), "main");
    private final String type;
    protected final MaterialSet materials;
    protected final Model.Simple headModel;
    protected final Model.Simple footModel;

    public BaseComfortsBlockEntityRenderer(BlockEntityRendererProvider.Context context, String type, ModelLayerLocation headModel, ModelLayerLocation footModel) {
        this(type, context.materials(), context.entityModelSet(), headModel, footModel);
    }

    public BaseComfortsBlockEntityRenderer(SpecialModelRenderer.BakingContext context, String type, ModelLayerLocation headModel, ModelLayerLocation footModel) {
        this(type, context.materials(), context.entityModelSet(), headModel, footModel);
    }

    public BaseComfortsBlockEntityRenderer(String type, MaterialSet materials, EntityModelSet modelSet, ModelLayerLocation headModel, ModelLayerLocation footModel) {
        this.headModel = new Model.Simple(modelSet.bakeLayer(headModel), RenderType::entitySolid);
        this.footModel = new Model.Simple(modelSet.bakeLayer(footModel), RenderType::entitySolid);
        this.materials = materials;
        this.type = type;
    }

    @Nonnull
    public BedRenderState createRenderState() {
        return new BedRenderState();
    }

    public void extractRenderState(@Nonnull BaseComfortsBlockEntity comfortsBlockEntity, @Nonnull BedRenderState bedRenderState, float partialTicks, @Nonnull Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)comfortsBlockEntity, (BlockEntityRenderState)bedRenderState, partialTicks, cameraPosition, breakProgress);
        bedRenderState.color = comfortsBlockEntity.getColor();
        bedRenderState.facing = (Direction)comfortsBlockEntity.getBlockState().getValue((Property)BedBlock.FACING);
        boolean bl = bedRenderState.isHead = comfortsBlockEntity.getBlockState().getValue((Property)BedBlock.PART) == BedPart.HEAD;
        if (comfortsBlockEntity.getLevel() != null) {
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)BlockEntityType.BED, BedBlock::getBlockType, BedBlock::getConnectedDirection, (Property)ChestBlock.FACING, (BlockState)comfortsBlockEntity.getBlockState(), (LevelAccessor)comfortsBlockEntity.getLevel(), (BlockPos)comfortsBlockEntity.getBlockPos(), (p_112202_, p_112203_) -> false);
            bedRenderState.lightCoords = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(bedRenderState.lightCoords);
        }
    }

    public void submit(@Nonnull BedRenderState bedRenderState, @Nonnull PoseStack poseStack, @Nonnull SubmitNodeCollector nodeCollector, @Nonnull CameraRenderState cameraRenderState) {
        Material material = new Material(ResourceLocation.withDefaultNamespace((String)"textures/atlas/blocks.png"), ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)("entity/" + this.type + "/" + bedRenderState.color.getName())));
        this.submitPiece(poseStack, nodeCollector, bedRenderState.isHead ? this.headModel : this.footModel, bedRenderState.facing, material, bedRenderState.lightCoords, OverlayTexture.NO_OVERLAY, false, bedRenderState.breakProgress, 0);
    }

    private void submitPiece(PoseStack poseStack, SubmitNodeCollector nodeCollector, Model.Simple model, Direction direction, Material material, int packedLight, int packedOverlay, boolean isFeet, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, int outlineColor) {
        poseStack.pushPose();
        BaseComfortsBlockEntityRenderer.preparePose(poseStack, isFeet, direction);
        nodeCollector.submitModel((Model)model, (Object)Unit.INSTANCE, poseStack, material.renderType(RenderType::entitySolid), packedLight, packedOverlay, -1, this.materials.get(material), outlineColor, crumblingOverlay);
        poseStack.popPose();
    }

    private static void preparePose(PoseStack poseStack, boolean isFeet, Direction direction) {
        poseStack.translate(0.0, 0.1875, isFeet ? -1.0 : 0.0);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f + direction.toYRot()));
        poseStack.translate(-0.5, -0.5, -0.5);
    }
}

