/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.ComfortsConstants;
import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.HammockBlock;
import com.illusivesoulworks.comforts.common.block.SleepingBagBlock;
import com.illusivesoulworks.comforts.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ComfortsEvents {
    private static final List<MobEffectInstance> SLEEPING_BAG_EFFECTS = new ArrayList<MobEffectInstance>();
    static boolean effectsInitialized = false;

    public static boolean canSetSpawn(Player player, BlockPos pos) {
        Level level = player.level();
        if (pos != null && !player.level().isClientSide()) {
            Block block = level.getBlockState(pos).getBlock();
            return !(block instanceof SleepingBagBlock) && !(block instanceof HammockBlock);
        }
        return true;
    }

    public static Result checkTime(Level level, BlockPos pos) {
        long time = level.getDayTime() % 24000L;
        ComfortsConfig.ComfortsTimeUse timeUse = ComfortsConfig.ComfortsTimeUse.NIGHT;
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof HammockBlock) {
            timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)ComfortsConfig.SERVER.hammockUse.get());
        } else if (block instanceof SleepingBagBlock) {
            timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)ComfortsConfig.SERVER.sleepingBagUse.get());
        }
        if (time > 500L && time < 11500L && (timeUse == ComfortsConfig.ComfortsTimeUse.DAY || timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT)) {
            return Result.ALLOW;
        }
        if (timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT || timeUse == ComfortsConfig.ComfortsTimeUse.NIGHT) {
            return Result.DEFAULT;
        }
        return Result.DENY;
    }

    public static long getWakeTime(ServerLevel level, long currentTime, long newTime) {
        boolean[] daySleeping = new boolean[]{false};
        List players = level.players();
        for (Player player : players) {
            player.getSleepingPos().ifPresent(bedPos -> {
                if (player.isSleepingLongEnough()) {
                    ComfortsConfig.ComfortsTimeUse timeUse = ComfortsConfig.ComfortsTimeUse.NIGHT;
                    Block block = level.getBlockState(bedPos).getBlock();
                    if (block instanceof HammockBlock) {
                        timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.hammockUse.get()));
                    } else if (block instanceof SleepingBagBlock) {
                        timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.sleepingBagUse.get()));
                    }
                    if (timeUse == ComfortsConfig.ComfortsTimeUse.DAY || timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT) {
                        daySleeping[0] = true;
                    }
                }
            });
            if (!daySleeping[0]) continue;
            break;
        }
        if (daySleeping[0] && level.getLevel().isBrightOutside()) {
            long i = currentTime + 24000L;
            long result = i - i % 24000L - 12001L;
            return Math.max((long)((Integer)ComfortsConfig.SERVER.nightWakeTimeOffset.get()).intValue() + result, currentTime);
        }
        return Math.max(newTime + (long)((Integer)ComfortsConfig.SERVER.dayWakeTimeOffset.get()).intValue(), currentTime);
    }

    public static void onWakeUp(Player player) {
        Level level = player.level();
        if (!level.isClientSide()) {
            Services.SLEEP_EVENTS.getSleepData(player).ifPresent(data -> player.getSleepingPos().ifPresent(bedPos -> {
                long wakeTime = level.getDayTime();
                long timeSlept = wakeTime - data.getSleepTime();
                BlockState state = level.getBlockState(bedPos);
                if (state.getBlock() instanceof SleepingBagBlock) {
                    boolean broke = false;
                    if (timeSlept > 500L) {
                        AttributeInstance attributeInstance;
                        List<MobEffectInstance> effectInstances;
                        if (!effectsInitialized) {
                            ComfortsEvents.initializeEffects();
                            effectsInitialized = true;
                        }
                        if (!(effectInstances = SLEEPING_BAG_EFFECTS).isEmpty()) {
                            for (MobEffectInstance effect : effectInstances) {
                                player.addEffect(new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier()));
                            }
                        }
                        double breakChance = (double)((Integer)ComfortsConfig.SERVER.sleepingBagBreakChance.get()).intValue() / 100.0;
                        double luckMultiplier = (Double)ComfortsConfig.SERVER.sleepingBagBreakChanceLuckMultiplier.get();
                        if (luckMultiplier > 0.0 && (attributeInstance = player.getAttribute(Attributes.LUCK)) != null) {
                            breakChance -= luckMultiplier * attributeInstance.getValue();
                        }
                        if (level.random.nextDouble() < breakChance) {
                            broke = true;
                            BlockPos blockpos = bedPos.relative(((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite());
                            level.removeBlock(bedPos, false);
                            level.removeBlock(blockpos, false);
                            player.displayClientMessage((Component)Component.translatable((String)"item.comforts.sleeping_bag.broke"), true);
                            level.playSound(null, bedPos, SoundEvents.WOOL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                            player.clearSleepingPos();
                        }
                    }
                    if (!broke && data.getAutoSleepPos() != null) {
                        BlockPos blockpos = bedPos.relative(((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite());
                        if (!player.isCreative()) {
                            level.removeBlock(blockpos, false);
                            level.removeBlock(bedPos, false);
                        } else {
                            level.removeBlock(bedPos, false);
                            level.removeBlock(blockpos, false);
                        }
                        player.clearSleepingPos();
                    }
                }
                data.setWakeTime(wakeTime);
                data.setTiredTime(wakeTime + (long)((double)timeSlept / (Double)ComfortsConfig.SERVER.restMultiplier.get()));
                data.setAutoSleepPos(null);
            }));
        }
    }

    private static void initializeEffects() {
        SLEEPING_BAG_EFFECTS.clear();
        ((List)ComfortsConfig.SERVER.sleepingBagEffects.get()).forEach(effect -> {
            String[] elements = effect.split(";");
            Holder<MobEffect> mobEffect = Services.REGISTRY_UTIL.getMobEffect(ResourceLocation.tryParse((String)elements[0]));
            if (mobEffect == null) {
                return;
            }
            int duration = 0;
            int amp = 0;
            try {
                duration = Math.max(1, Math.min(Integer.parseInt(elements[1]), 1600));
                amp = Math.max(1, Math.min(Integer.parseInt(elements[2]), 4));
            }
            catch (Exception e) {
                ComfortsConstants.LOG.error("Problem parsing sleeping bag effects in config!", (Throwable)e);
            }
            SLEEPING_BAG_EFFECTS.add(new MobEffectInstance(mobEffect, duration * 20, amp - 1));
        });
    }

    public static Player.BedSleepingProblem onSleep(Player player) {
        if (!player.level().isClientSide()) {
            return Services.SLEEP_EVENTS.getSleepData(player).map(data -> {
                long dayTime = player.level().getDayTime();
                data.setSleepTime(dayTime);
                if (((Boolean)ComfortsConfig.SERVER.restrictSleeping.get()).booleanValue()) {
                    if (data.getWakeTime() > dayTime) {
                        data.setWakeTime(0L);
                        data.setTiredTime(0L);
                    }
                    if (data.getTiredTime() > dayTime) {
                        player.displayClientMessage((Component)Component.translatable((String)"capability.comforts.not_sleepy"), true);
                        return Player.BedSleepingProblem.OTHER_PROBLEM;
                    }
                }
                return null;
            }).orElse(null);
        }
        return null;
    }

    public static int sleepersNeeded(int activePlayers) {
        int percentage = (Integer)ComfortsConfig.SERVER.daySleepingPercentage.get();
        if (percentage < 0) {
            return 0;
        }
        return Math.max(1, Mth.ceil((float)((float)(activePlayers * percentage) / 100.0f)));
    }

    public static boolean announceSleepStatus(SleepStatus sleepStatus, ServerLevel serverLevel) {
        MinecraftServer server = serverLevel.getServer();
        if (!serverLevel.isBrightOutside()) {
            return false;
        }
        if (!server.isSingleplayer() || server.isPublished()) {
            int percentage = (Integer)ComfortsConfig.SERVER.daySleepingPercentage.get();
            if (percentage < 0) {
                percentage = serverLevel.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
            }
            if (percentage > 100) {
                return false;
            }
            MutableComponent component = sleepStatus.areEnoughSleeping(percentage) ? Component.translatable((String)"comforts.skipping_day") : Component.translatable((String)"sleep.players_sleeping", (Object[])new Object[]{sleepStatus.amountSleeping(), sleepStatus.sleepersNeeded(percentage)});
            for (ServerPlayer player : serverLevel.players()) {
                player.displayClientMessage((Component)component, true);
            }
            return true;
        }
        return false;
    }

    public static enum Result {
        ALLOW,
        DEFAULT,
        DENY;

    }
}

