/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.platform;

import com.illusivesoulworks.comforts.common.CapabilitySleepData;
import com.illusivesoulworks.comforts.common.capability.ISleepData;
import com.illusivesoulworks.comforts.common.network.ComfortsForgeNetwork;
import com.illusivesoulworks.comforts.common.network.SPacketAutoSleep;
import com.illusivesoulworks.comforts.common.network.SPacketPlaceBag;
import com.illusivesoulworks.comforts.platform.services.ISleepEvents;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;

public class ForgeSleepEvents
implements ISleepEvents {
    @Override
    public Player.BedSleepingProblem getSleepResult(ServerPlayer player, BlockPos pos) {
        return ForgeEventFactory.onPlayerSleepInBed((Player)player, Optional.of(pos));
    }

    @Override
    public Either<Player.BedSleepingProblem, Unit> getSleepResult(ServerPlayer player, BlockPos pos, Either<Player.BedSleepingProblem, Unit> vanillaResult) {
        return vanillaResult;
    }

    @Override
    public boolean isAwakeTime(Player player, BlockPos pos) {
        return !ForgeEventFactory.onSleepingTimeCheck((Player)player, Optional.of(pos));
    }

    @Override
    public Optional<? extends ISleepData> getSleepData(Player player) {
        return CapabilitySleepData.getCapability(player).resolve();
    }

    @Override
    public void sendAutoSleepPacket(ServerPlayer player, BlockPos pos) {
        ComfortsForgeNetwork.INSTANCE.send((Object)new SPacketAutoSleep(player.getId(), pos), PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public void sendPlaceBagPacket(ServerPlayer player, UseOnContext context) {
        ComfortsForgeNetwork.INSTANCE.send((Object)new SPacketPlaceBag(player.getId(), context.getHand(), context.getClickedFace(), context.getClickedPos(), context.getClickLocation().toVector3f(), context.isInside()), PacketDistributor.PLAYER.with((Object)player));
    }
}

