/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.data;

import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import com.illusivesoulworks.comforts.data.HammockEnabledCondition;
import com.illusivesoulworks.comforts.data.SleepingBagEnabledCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;

public class ComfortsRecipeProvider
extends RecipeProvider {
    private final HolderLookup.RegistryLookup<Item> items;

    public ComfortsRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
        this.items = provider.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        List<TagKey<Item>> dyes = List.of(Tags.Items.DYES_WHITE, Tags.Items.DYES_ORANGE, Tags.Items.DYES_MAGENTA, Tags.Items.DYES_LIGHT_BLUE, Tags.Items.DYES_YELLOW, Tags.Items.DYES_LIME, Tags.Items.DYES_PINK, Tags.Items.DYES_GRAY, Tags.Items.DYES_LIGHT_GRAY, Tags.Items.DYES_CYAN, Tags.Items.DYES_PURPLE, Tags.Items.DYES_BLUE, Tags.Items.DYES_BROWN, Tags.Items.DYES_GREEN, Tags.Items.DYES_RED, Tags.Items.DYES_BLACK);
        List<Item> hammocks = ComfortsRegistry.HAMMOCKS.values().stream().map(blockRegistryObject -> ((Block)blockRegistryObject.get()).asItem()).toList();
        List<Item> sleepingBags = ComfortsRegistry.SLEEPING_BAGS.values().stream().map(blockRegistryObject -> ((Block)blockRegistryObject.get()).asItem()).toList();
        List<Item> wool = List.of(Items.WHITE_WOOL, Items.ORANGE_WOOL, Items.MAGENTA_WOOL, Items.LIGHT_BLUE_WOOL, Items.YELLOW_WOOL, Items.LIME_WOOL, Items.PINK_WOOL, Items.GRAY_WOOL, Items.LIGHT_GRAY_WOOL, Items.CYAN_WOOL, Items.PURPLE_WOOL, Items.BLUE_WOOL, Items.BROWN_WOOL, Items.GREEN_WOOL, Items.RED_WOOL, Items.BLACK_WOOL);
        for (int i = 0; i < wool.size(); ++i) {
            this.sleepingBag((ItemLike)sleepingBags.get(i), (ItemLike)wool.get(i));
            this.hammock((ItemLike)hammocks.get(i), (ItemLike)wool.get(i));
        }
        this.colorWithDye(HammockEnabledCondition.INSTANCE, dyes, hammocks, "comforts:hammock");
        this.colorWithDye(SleepingBagEnabledCondition.INSTANCE, dyes, sleepingBags, "comforts:sleeping_bag");
        Item ropeAndNail = ComfortsRegistry.ROPE_AND_NAIL_ITEM.get();
        ConditionalRecipe.builder().condition((ICondition)HammockEnabledCondition.INSTANCE).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ropeAndNail, (int)2).define(Character.valueOf('A'), Tags.Items.STRINGS).define(Character.valueOf('X'), Tags.Items.INGOTS_IRON).pattern("AA ").pattern("AX ").pattern("  A").group("comforts:rope_and_nail").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON))).save(arg_0)).save(this.output, RecipeBuilder.getDefaultRecipeId((ItemLike)ropeAndNail));
        ArrayList<HammockEnabledCondition> conditions = new ArrayList<HammockEnabledCondition>();
        conditions.add(HammockEnabledCondition.INSTANCE);
        conditions.add((HammockEnabledCondition)new NotCondition((ICondition)new TagEmptyCondition(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ropes")))));
        ConditionalRecipe.builder().condition((ICondition)new AndCondition(conditions)).recipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ropeAndNail, (int)2).requires(Tags.Items.INGOTS_IRON).requires(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ropes"))).group("comforts:rope_and_nail").unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON))).save(arg_0)).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)("shapeless_" + ComfortsRecipeProvider.getItemName((ItemLike)ropeAndNail))));
    }

    protected void colorWithDye(ICondition condition, List<TagKey<Item>> pDyes, List<Item> pDyeableItems, String pGroup) {
        for (int i = 0; i < pDyes.size(); ++i) {
            TagKey<Item> dye = pDyes.get(i);
            Item item = pDyeableItems.get(i);
            ConditionalRecipe.builder().condition(condition).recipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).requires(dye).requires(Ingredient.of(pDyeableItems.stream().filter(val -> !val.equals(item)))).group(pGroup).unlockedBy("has_needed_dye", this.has(dye))).save(arg_0)).save(this.output, ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)("dye_" + ComfortsRecipeProvider.getItemName((ItemLike)item))));
        }
    }

    protected void sleepingBag(ItemLike pBed, ItemLike pWool) {
        ConditionalRecipe.builder().condition((ICondition)SleepingBagEnabledCondition.INSTANCE).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)pBed).define(Character.valueOf('#'), pWool).pattern(" # ").pattern(" # ").pattern(" # ").group("comforts:sleeping_bag").unlockedBy(ComfortsRecipeProvider.getHasName((ItemLike)pWool), this.has(pWool))).save(arg_0)).save(this.output, RecipeBuilder.getDefaultRecipeId((ItemLike)pBed));
    }

    protected void hammock(ItemLike pBed, ItemLike pWool) {
        ConditionalRecipe.builder().condition((ICondition)HammockEnabledCondition.INSTANCE).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)pBed).define(Character.valueOf('#'), pWool).define(Character.valueOf('S'), Tags.Items.STRINGS).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).pattern(" X ").pattern("S#S").pattern(" X ").group("comforts:hammock").unlockedBy(ComfortsRecipeProvider.getHasName((ItemLike)pWool), this.has(pWool))).save(arg_0)).save(this.output, RecipeBuilder.getDefaultRecipeId((ItemLike)pBed));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        @Nonnull
        public String getName() {
            return "comforts";
        }

        @Nonnull
        protected RecipeProvider createRecipeProvider(@Nonnull HolderLookup.Provider registries, @Nonnull RecipeOutput output) {
            return new ComfortsRecipeProvider(registries, output);
        }
    }
}

