/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerStatueBlock
extends Block {
    public static EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static DirectionProperty FACING = BlockStateProperties.FACING;
    private static final VoxelShape TOP_SHAPE_NS;
    private static final VoxelShape TOP_SHAPE_WE;
    private static final VoxelShape BOTTOM_SHAPE_NS;
    private static final VoxelShape BOTTOM_SHAPE_WE;

    public VillagerStatueBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF}).add(new Property[]{FACING});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.NORTH, Direction.SOUTH -> BOTTOM_SHAPE_NS;
                default -> BOTTOM_SHAPE_WE;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> TOP_SHAPE_NS;
            default -> TOP_SHAPE_WE;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return null;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, @NotNull BlockState changedState, @NotNull LevelAccessor level, @NotNull BlockPos changedPos, @NotNull BlockPos p_52899_) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || changedState.is((Block)this) && changedState.getValue(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)level, changedPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, changedState, level, changedPos, p_52899_);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(state, level, pos);
        }
        BlockState blockstate = level.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, level, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placeState;
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState aboveState = level.getBlockState(blockpos.above());
        if (!level.isOutsideBuildHeight(blockpos) && aboveState.canBeReplaced(context) && Objects.nonNull(placeState = super.getStateForPlacement(context))) {
            return (BlockState)placeState.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity entity, @NotNull ItemStack stack) {
        BlockPos blockpos = pos.above();
        Direction facing = (Direction)state.getValue((Property)FACING);
        level.setBlock(blockpos, (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)FACING, (Comparable)facing), 3);
    }

    public BlockState playerWillDestroy(Level p_52878_, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!p_52878_.isClientSide) {
            if (player.isCreative()) {
                VillagerStatueBlock.preventCreativeDropFromBottomPart(p_52878_, pos, state, player);
            } else {
                VillagerStatueBlock.dropResources((BlockState)state, (Level)p_52878_, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(p_52878_, pos, state, player);
    }

    public void playerDestroy(@NotNull Level p_52865_, @NotNull Player p_52866_, @NotNull BlockPos p_52867_, @NotNull BlockState p_52868_, @javax.annotation.Nullable BlockEntity p_52869_, @NotNull ItemStack p_52870_) {
        super.playerDestroy(p_52865_, p_52866_, p_52867_, Blocks.AIR.defaultBlockState(), p_52869_, p_52870_);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState emptyState = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockpos, emptyState, 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    static {
        BOTTOM_SHAPE_NS = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.box((double)4.0, (double)1.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), (BooleanOp)BooleanOp.OR);
        BOTTOM_SHAPE_WE = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.box((double)6.0, (double)1.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.OR);
        TOP_SHAPE_NS = Shapes.join((VoxelShape)Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0), (BooleanOp)BooleanOp.OR);
        TOP_SHAPE_WE = Shapes.join((VoxelShape)Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)10.0, (double)12.0), (BooleanOp)BooleanOp.OR);
    }
}

