/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.inventory;

import com.dolthhaven.easeldoesit.core.other.EaselModTrackedData;
import com.dolthhaven.easeldoesit.core.registry.EaselModBlocks;
import com.dolthhaven.easeldoesit.core.registry.EaselModMenuTypes;
import com.dolthhaven.easeldoesit.core.registry.EaselModSoundEvents;
import com.dolthhaven.easeldoesit.other.util.MathUtil;
import com.dolthhaven.easeldoesit.other.util.PaintingUtil;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class EaselMenu
extends AbstractContainerMenu {
    private static final int MIN_DIMENSION = 1;
    private static final int MAX_DIMENSION = 4;
    private static final List<PaintingVariant> EMPTY = List.of();
    private final ContainerLevelAccess access;
    private final Level level;
    long lastSoundTime;
    Runnable slotUpdateListener = () -> {};
    public final Slot inputSlot;
    public final Slot resultSlot;
    public final Container inputContainer = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            EaselMenu.this.slotsChanged((Container)this);
            EaselMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();
    private final DataSlot paintingHeight = DataSlot.standalone();
    private final DataSlot paintingWidth = DataSlot.standalone();
    private final DataSlot paintingIndex = DataSlot.standalone();
    private final DataSlot[] savedIndexInEachDimension = new DataSlot[16];
    private final List<List<PaintingVariant>> possiblePaintings = new ArrayList<List<PaintingVariant>>(16);

    public EaselMenu(int id, Inventory inv) {
        this(id, inv, ContainerLevelAccess.NULL);
    }

    public EaselMenu(int id, Inventory inv, final ContainerLevelAccess access) {
        super(EaselModMenuTypes.EASEL_MENU.get(), id);
        this.level = inv.player.level();
        this.access = access;
        this.inputSlot = this.addSlot(new Slot(this, this.inputContainer, 0, 15, 35){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.is(Items.PAINTING);
            }
        });
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 143, 35){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                ItemStack input = EaselMenu.this.inputSlot.remove(1);
                if (!input.isEmpty()) {
                    EaselMenu.this.createResult();
                }
                access.execute((level, pos) -> {
                    long l = level.getGameTime();
                    if (EaselMenu.this.lastSoundTime != l) {
                        level.playSound(null, pos, (SoundEvent)EaselModSoundEvents.UI_EASEL_TAKE_RESULT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        EaselMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(player, stack);
            }
        });
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        for (int i = 0; i < 16; ++i) {
            DataSlot data = DataSlot.standalone();
            data.set(0);
            this.addDataSlot(data);
            this.savedIndexInEachDimension[i] = data;
        }
        this.addDataSlot(this.paintingHeight);
        this.addDataSlot(this.paintingWidth);
        this.addDataSlot(this.paintingIndex);
        this.syncPlayerData(inv.player);
        this.initPaintings(this.level.registryAccess());
    }

    public void slotsChanged(@NotNull Container container) {
        super.slotsChanged(container);
        if (container == this.inputContainer) {
            this.createResult();
        }
    }

    private void createResult() {
        if (this.inputSlot.getItem().is(Items.PAINTING) && this.getCurrentPainting().isPresent()) {
            this.getCurrentPainting().ifPresent(variant -> {
                ItemStack stack = PaintingUtil.makeStack(variant, this.level.registryAccess());
                this.resultSlot.set(stack);
            });
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public void dimensionChangedPre() {
        this.savePaintingForCurrentDimension();
    }

    public void dimensionChangedPost() {
        ItemStack inputStack = this.inputSlot.getItem();
        this.setPaintingIndex(this.savedIndex());
        if (inputStack.is(Items.PAINTING)) {
            this.createResult();
        }
    }

    private int savedIndex() {
        if (!this.isLegalDimensions()) {
            return -1;
        }
        int serializedCord = this.encodeCords();
        return this.savedIndexInEachDimension[serializedCord].get();
    }

    public void indexChanged() {
        this.createResult();
    }

    public List<PaintingVariant> getPaintings() {
        return this.isLegalDimensions() ? this.possiblePaintings.get(this.encodeCords()) : EMPTY;
    }

    private void savePaintingForCurrentDimension() {
        if (!this.isLegalDimensions()) {
            return;
        }
        this.savedIndexInEachDimension[this.encodeCords()].set(this.getPaintingIndex());
    }

    public int getPaintingHeight() {
        return this.paintingHeight.get();
    }

    public int getPaintingWidth() {
        return this.paintingWidth.get();
    }

    public void setPaintingHeight(int newHeight) {
        this.dimensionChangedPre();
        this.paintingHeight.set(newHeight);
        this.dimensionChangedPost();
    }

    public void setPaintingWidth(int newWidth) {
        this.dimensionChangedPre();
        this.paintingWidth.set(newWidth);
        this.dimensionChangedPost();
    }

    public int getPossiblePaintingsSize() {
        return this.getPaintings().size();
    }

    public int getPaintingIndex() {
        return this.paintingIndex.get();
    }

    public void setPaintingIndex(int newIndex) {
        this.paintingIndex.set(newIndex);
        this.indexChanged();
    }

    public boolean isLegalIndex() {
        return this.isLegalIndex(this.getPaintingIndex());
    }

    public boolean isLegalIndex(int index) {
        return index >= 0 && index < this.getPossiblePaintingsSize();
    }

    public boolean isLegalDimensions() {
        if (this.getPaintingHeight() < 1 || this.getPaintingHeight() > 4) {
            return false;
        }
        return this.getPaintingWidth() >= 1 && this.getPaintingWidth() <= 4;
    }

    public Optional<PaintingVariant> getCurrentPainting() {
        PaintingVariant variant = !this.isLegalIndex() ? null : this.getPaintings().get(this.getPaintingIndex());
        return Optional.ofNullable(variant);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack input = slot.getItem();
        Item item = input.getItem();
        ItemStack inputCopy = input.copy();
        if (index == this.inputSlot.getSlotIndex()) {
            item.onCraftedBy(input, player.level(), player);
            if (!this.moveItemStackTo(input, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(input, inputCopy);
        } else if (index == this.resultSlot.getSlotIndex() ? !this.moveItemStackTo(input, 2, 38, true) : (input.is(Items.PAINTING) ? !this.moveItemStackTo(input, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(input, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(input, 2, 29, false)))) {
            return ItemStack.EMPTY;
        }
        if (input.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        }
        slot.setChanged();
        if (input.getCount() == inputCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, input);
        this.broadcastChanges();
        return inputCopy;
    }

    public boolean stillValid(@NotNull Player player) {
        return EaselMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)EaselModBlocks.EASEL.get()));
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    private int encodeCords() {
        return this.encodeCords(this.getPaintingWidth(), this.getPaintingHeight());
    }

    private int encodeCords(int width, int height) {
        if (width == 0 || height == 0) {
            return -1;
        }
        return MathUtil.base4Minus5(width, height);
    }

    @NotNull
    public MenuType<?> getType() {
        return EaselModMenuTypes.EASEL_MENU.get();
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((p_40313_, p_40314_) -> this.clearContainer(player, this.inputContainer));
        this.savePainting(player);
    }

    private void savePainting(@NotNull Player player) {
        if (!this.isLegalDimensions()) {
            return;
        }
        IDataManager manager = (IDataManager)player;
        short paintingIndex = EaselModTrackedData.encodePainting(new int[]{this.getPaintingWidth() - 1, this.getPaintingHeight() - 1, this.getPaintingIndex()});
        manager.setValue(EaselModTrackedData.PLAYER_CURRENT_PAINTING_INDEX, (Object)paintingIndex);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int invRow = 0; invRow < 3; ++invRow) {
            for (int invCol = 0; invCol < 9; ++invCol) {
                this.addSlot(new Slot((Container)playerInventory, invCol + invRow * 9 + 9, 8 + invCol * 18, 84 + invRow * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    private void syncPlayerData(Player player) {
        short savedPaintingData = (Short)((IDataManager)player).getValue(EaselModTrackedData.PLAYER_CURRENT_PAINTING_INDEX);
        if (savedPaintingData == 0) {
            this.setPaintingWidth(0);
            this.setPaintingHeight(0);
            this.setPaintingIndex(0);
        } else {
            Vec3i dataInfo = EaselModTrackedData.decodePainting(savedPaintingData);
            this.setPaintingWidth(dataInfo.getX());
            this.setPaintingHeight(dataInfo.getY());
            this.setPaintingIndex(dataInfo.getZ());
        }
    }

    private void initPaintings(RegistryAccess access) {
        for (int i = 0; i < 16; ++i) {
            this.possiblePaintings.add(new ArrayList());
        }
        PaintingUtil.tagged((TagKey<PaintingVariant>)PaintingVariantTags.PLACEABLE, access, painting -> painting.width() <= 4 && painting.height() <= 4).forEach(painting -> {
            int entry = this.encodeCords(painting.width(), painting.height());
            this.possiblePaintings.get(entry).add((PaintingVariant)painting);
        });
        this.possiblePaintings.forEach(list -> list.sort(Comparator.comparing(PaintingVariant::assetId)));
    }
}

