/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.inventory;

import com.dolthhaven.easeldoesit.common.inventory.EaselMenu;
import com.dolthhaven.easeldoesit.common.network.packets.C2SSetEaselDimensionsPacket;
import com.dolthhaven.easeldoesit.common.network.packets.C2SSetEaselPaintingIndexPacket;
import com.dolthhaven.easeldoesit.core.EaselDoesIt;
import com.dolthhaven.easeldoesit.other.util.MathUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@OnlyIn(value=Dist.CLIENT)
public class EaselScreen
extends AbstractContainerScreen<EaselMenu> {
    private static final ResourceLocation BG_LOCATION = EaselDoesIt.rl("textures/gui/container/easel.png");
    private final int imageWidth;
    private final int imageHeight;
    private int leftPos;
    private int topPos;
    private float untilNextScroll = 0.0f;
    private final EaselWidthButton[] paintingWidthButtons = new EaselWidthButton[4];
    private final EaselHeightsButton[] paintingHeightButtons = new EaselHeightsButton[4];
    private final EaselPickerButton[] paintingPickers = new EaselPickerButton[2];
    private static final int PAINTINGS_PER_PAGE = 8;
    private static final int PIXELS_PER_PAGE = 51;
    private static final int PREVIEW_BOX_SIZE = 64;
    private static final int PAGES_START_X = 126;
    private static final Vector2i PAGE_BUTTON = new Vector2i(181, 23);
    private static final Vector2i PAGE_BUTTON_SELECTED = new Vector2i(176, 23);
    private static final int PAGE_BUTTON_SIZE = 5;
    private static final int PAGE_BUTTONS_START = 21;
    private static final int BUTTONS_DIMENSIONS_LONG = 16;
    private static final int BUTTONS_DIMENSIONS_SHORT = 7;
    private static final int HEIGHT_BUTTONS_START_X = 48;
    private static final int HEIGHT_BUTTONS_START_Y = 14;
    private static final Vector2i WIDTH_BUTTONS_START_GUI = new Vector2i(56, 6);
    private static final int PICKER_X = 123;
    private static final int PICKER_TOP_Y = 14;
    private static final int PICKER_BOTTOM_Y = 72;
    private static final int PICKER_X_DIMENSION = 11;
    private static final int PICKER_Y_DIMENSION = 7;
    private static final int PICKER_ATLAS_Y = 28;
    private static final Vector2i PICKER_TOP_UV = new Vector2i(187, 28);
    private static final Vector2i PICKER_TOP_HOVERED_UV = new Vector2i(209, 28);
    private static final Vector2i PICKER_TOP_INACTIVE_UV = new Vector2i(231, 28);
    private static final Vector2i PICKER_BOTTOM_UV = new Vector2i(176, 28);
    private static final Vector2i PICKER_BOTTOM_HOVERED_UV = new Vector2i(198, 28);
    private static final Vector2i PICKER_BOTTOM_INACTIVE_UV = new Vector2i(220, 28);
    private static final Vector2i PREVIEW_BOX_GUI = new Vector2i(56, 14);
    private static final Vector2i PREVIEW_BOX_UV = new Vector2i(176, 35);
    private static final Vector2i WIDTH_BUTTON_NOT_CLICKED = new Vector2i(183, 0);
    private static final Vector2i WIDTH_BUTTON_CLICKED = new Vector2i(176, 16);
    private static final Vector2i WIDTH_BUTTON_HOVERED = new Vector2i(206, 0);
    private static final Vector2i HEIGHT_BUTTON_NOT_CLICKED = new Vector2i(192, 7);
    private static final Vector2i HEIGHT_BUTTON_CLICKED = new Vector2i(176, 0);
    private static final Vector2i HEIGHT_BUTTON_HOVERED = new Vector2i(199, 0);

    public EaselScreen(EaselMenu menu, Inventory inv, Component component) {
        super((AbstractContainerMenu)menu, inv, component);
        ((EaselMenu)this.menu).registerUpdateListener(this::containerChanged);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.inventoryLabelY = 1000;
        this.addHeightButtons();
        this.addWidthButtons();
        this.addPickers();
    }

    private void addWidthButtons() {
        for (int i = 1; i <= 4; ++i) {
            EaselWidthButton button = new EaselWidthButton(this.leftPos + WIDTH_BUTTONS_START_GUI.x() + 16 * (i - 1), this.topPos + WIDTH_BUTTONS_START_GUI.y(), i);
            button.active = false;
            this.addRenderableWidget((GuiEventListener)button);
            this.paintingWidthButtons[i - 1] = button;
        }
    }

    private void addHeightButtons() {
        for (int i = 1; i <= 4; ++i) {
            EaselHeightsButton button = new EaselHeightsButton(this.leftPos + 48, this.topPos + 14 + 16 * (i - 1), i);
            button.active = false;
            this.addRenderableWidget((GuiEventListener)button);
            this.paintingHeightButtons[i - 1] = button;
        }
    }

    private void addPickers() {
        EaselPickerButton topPicker = new EaselPickerButton(this, this.leftPos + 123, this.topPos + 14, this){

            @Override
            int affectIndex(int oldIndex) {
                return oldIndex - 1;
            }

            @Override
            List<Vector2i> atlasCords() {
                return List.of(PICKER_TOP_INACTIVE_UV, PICKER_TOP_HOVERED_UV, PICKER_TOP_UV);
            }
        };
        EaselPickerButton bottomPicker = new EaselPickerButton(this, this.leftPos + 123, this.topPos + 72, this){

            @Override
            int affectIndex(int oldIndex) {
                return oldIndex + 1;
            }

            @Override
            List<Vector2i> atlasCords() {
                return List.of(PICKER_BOTTOM_INACTIVE_UV, PICKER_BOTTOM_HOVERED_UV, PICKER_BOTTOM_UV);
            }
        };
        topPicker.active = false;
        bottomPicker.active = false;
        this.paintingPickers[0] = topPicker;
        this.paintingPickers[1] = bottomPicker;
        this.addRenderableWidget((GuiEventListener)topPicker);
        this.addRenderableWidget((GuiEventListener)bottomPicker);
    }

    private void containerChanged() {
        if (this.isEaselActive()) {
            for (EaselHeightsButton easelHeightsButton : this.paintingHeightButtons) {
                easelHeightsButton.active = true;
            }
            for (EaselDimensionsButton easelDimensionsButton : this.paintingWidthButtons) {
                easelDimensionsButton.active = true;
            }
            for (AbstractButton abstractButton : this.paintingPickers) {
                if (!abstractButton.canBePressed(((EaselMenu)this.menu).getPaintingIndex())) continue;
                abstractButton.active = true;
            }
        } else {
            for (EaselHeightsButton easelHeightsButton : this.paintingHeightButtons) {
                easelHeightsButton.active = false;
            }
            for (EaselDimensionsButton easelDimensionsButton : this.paintingWidthButtons) {
                easelDimensionsButton.active = false;
            }
            for (AbstractButton abstractButton : this.paintingPickers) {
                abstractButton.active = false;
            }
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        double potentialIndex = this.subtractInputFromScroll(scrollY);
        float remainders = (float)potentialIndex - (float)Mth.floor((double)potentialIndex);
        this.untilNextScroll += remainders;
        if (this.untilNextScroll > 1.0f) {
            this.untilNextScroll -= 1.0f;
            potentialIndex += 1.0;
        }
        this.setMenuIndex(Mth.floor((double)potentialIndex));
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.clickPageManager(mouseX, mouseY)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected double subtractInputFromScroll(double pInput) {
        Double2DoubleFunction scrollFunc = dub -> {
            double thresh;
            int sign = dub < 0.0 ? -1 : 1;
            double absDub = Math.abs(dub);
            if (absDub < (thresh = 3.2)) {
                return thresh * (double)sign;
            }
            return (thresh + thresh + absDub) / 3.0 * (double)sign;
        };
        pInput = (Double)scrollFunc.apply((Object)pInput);
        double multiplier = 1.1;
        double divide = (double)((EaselMenu)this.menu).getPossiblePaintingsSize() * multiplier;
        return Mth.clamp((double)((double)((EaselMenu)this.menu).getPaintingIndex() - pInput / divide), (double)0.0, (double)(((EaselMenu)this.menu).getPossiblePaintingsSize() - 1));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_LOCATION);
        graphics.blit(BG_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderPaintingGrid(graphics);
        this.renderPainting(graphics);
        this.renderPageManager(graphics);
    }

    private void renderPaintingGrid(GuiGraphics graphics) {
        if (this.isEaselActive()) {
            graphics.blit(BG_LOCATION, this.leftPos + PREVIEW_BOX_GUI.x(), this.topPos + PREVIEW_BOX_GUI.y(), PREVIEW_BOX_UV.x(), PREVIEW_BOX_UV.y(), 64, 64);
        }
    }

    private void renderPageManager(GuiGraphics graphics) {
        if (!this.isEaselActive() || !((EaselMenu)this.menu).isLegalDimensions()) {
            return;
        }
        int index = ((EaselMenu)this.getMenu()).getPaintingIndex();
        for (Vector2i coord : this.pageManagerInfo()) {
            int currentIndex = coord.x;
            int yPos = coord.y;
            boolean selected = currentIndex == index;
            Vector2i uv = selected ? PAGE_BUTTON_SELECTED : PAGE_BUTTON;
            graphics.blit(BG_LOCATION, this.leftPos + 126, this.topPos + yPos, uv.x(), uv.y(), 5, 5);
        }
    }

    private List<Vector2i> pageManagerInfo() {
        int menuPaintingIndex = ((EaselMenu)this.getMenu()).getPaintingIndex();
        int currentPage = Mth.ceil((double)((double)(menuPaintingIndex + 1) / 8.0));
        int numPaintings = Math.min(8, ((EaselMenu)this.getMenu()).getPossiblePaintingsSize() - 8 * (currentPage - 1));
        ArrayList<Vector2i> list = new ArrayList<Vector2i>();
        int yPos = (51 - this.totalReqPixelsFor(numPaintings)) / 2;
        yPos += 2;
        for (int i = 0; i < numPaintings; ++i) {
            list.add(new Vector2i((currentPage - 1) * 8 + i, yPos + 21));
            yPos += 6;
        }
        return list;
    }

    private boolean clickPageManager(double mouseX, double mouseY) {
        for (Vector2i buttons : this.pageManagerInfo()) {
            boolean notIdentityTransformation;
            int start = buttons.y();
            boolean inXRange = MathUtil.isBetween((int)mouseX, this.leftPos + 126, this.leftPos + 126 + 5);
            boolean inYRange = MathUtil.isBetween((int)mouseY, this.topPos + buttons.y(), this.topPos + buttons.y() + 5);
            boolean bl = notIdentityTransformation = buttons.x() != ((EaselMenu)this.getMenu()).getPaintingIndex();
            if (!inXRange || !inYRange || !notIdentityTransformation) continue;
            this.setMenuIndex(buttons.x());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }

    private int totalReqPixelsFor(int numPaintingsInPage) {
        return numPaintingsInPage * 6 + 3;
    }

    private void renderPainting(GuiGraphics graphics) {
        if (!(this.isEaselActive() && ((EaselMenu)this.menu).isLegalIndex() && ((EaselMenu)this.menu).isLegalDimensions())) {
            return;
        }
        ((EaselMenu)this.menu).getCurrentPainting().ifPresent(painting -> {
            TextureAtlasSprite paintingSprite = Minecraft.getInstance().getPaintingTextures().get(painting);
            graphics.blit(this.leftPos + PREVIEW_BOX_GUI.x(), this.topPos + PREVIEW_BOX_GUI.y(), 0, painting.width() * 16, painting.height() * 16, paintingSprite);
        });
    }

    private boolean isEaselActive() {
        return ((EaselMenu)this.getMenu()).inputSlot.getItem().is(Items.PAINTING);
    }

    private void setMenuPaintingWidth(int newWidth) {
        ((EaselMenu)this.menu).setPaintingWidth(newWidth);
        PacketDistributor.sendToServer((CustomPacketPayload)new C2SSetEaselDimensionsPacket(newWidth, ((EaselMenu)this.menu).getPaintingHeight()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.updatePickers(((EaselMenu)this.menu).getPaintingIndex());
    }

    private void setMenuPaintingHeight(int newHeight) {
        ((EaselMenu)this.menu).setPaintingHeight(newHeight);
        PacketDistributor.sendToServer((CustomPacketPayload)new C2SSetEaselDimensionsPacket(((EaselMenu)this.menu).getPaintingWidth(), newHeight), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.updatePickers(((EaselMenu)this.menu).getPaintingIndex());
    }

    private void setMenuIndex(int newIndex) {
        ((EaselMenu)this.menu).setPaintingIndex(newIndex);
        PacketDistributor.sendToServer((CustomPacketPayload)new C2SSetEaselPaintingIndexPacket(newIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.updatePickers(newIndex);
    }

    private void updatePickers(int newIndex) {
        for (EaselPickerButton button : this.paintingPickers) {
            button.active = button.canBePressed(newIndex);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class EaselWidthButton
    extends EaselDimensionsButton {
        public EaselWidthButton(int startX, int startY, int index) {
            super(startX, startY, 16, 7, index, EaselScreen.this);
        }

        public void onPress() {
            EaselScreen.this.setMenuPaintingWidth(this.index);
        }

        @Override
        protected List<Vector2i> atlasCords() {
            return List.of(WIDTH_BUTTON_CLICKED, WIDTH_BUTTON_NOT_CLICKED, WIDTH_BUTTON_HOVERED);
        }

        @Override
        protected int getRelevantDimension() {
            return ((EaselMenu)EaselScreen.this.getMenu()).getPaintingWidth();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class EaselHeightsButton
    extends EaselDimensionsButton {
        public EaselHeightsButton(int startX, int startY, int index) {
            super(startX, startY, 7, 16, index, EaselScreen.this);
        }

        public void onPress() {
            ((EaselMenu)EaselScreen.this.getMenu()).dimensionChangedPre();
            EaselScreen.this.setMenuPaintingHeight(this.index);
            ((EaselMenu)EaselScreen.this.getMenu()).dimensionChangedPost();
        }

        @Override
        protected List<Vector2i> atlasCords() {
            return List.of(HEIGHT_BUTTON_CLICKED, HEIGHT_BUTTON_NOT_CLICKED, HEIGHT_BUTTON_HOVERED);
        }

        @Override
        protected int getRelevantDimension() {
            return ((EaselMenu)EaselScreen.this.getMenu()).getPaintingHeight();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static abstract class EaselPickerButton
    extends AbstractButton {
        private final EaselScreen screen;

        public EaselPickerButton(int startX, int startY, EaselScreen screen) {
            super(startX, startY, 11, 7, CommonComponents.EMPTY);
            this.screen = screen;
            this.active = false;
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
            this.defaultButtonNarrationText(output);
        }

        abstract int affectIndex(int var1);

        abstract List<Vector2i> atlasCords();

        public void onPress() {
            int paintingIndex = ((EaselMenu)this.screen.getMenu()).getPaintingIndex();
            int newIndex = this.affectIndex(paintingIndex);
            if (this.canBePressed(paintingIndex)) {
                this.screen.setMenuIndex(newIndex);
            }
        }

        public boolean canBePressed(int index) {
            return ((EaselMenu)this.screen.getMenu()).isLegalIndex(this.affectIndex(index));
        }

        protected void renderWidget(@NotNull GuiGraphics graphics, int p_282682_, int p_281714_, float p_282542_) {
            if (!this.screen.isEaselActive() || ((EaselMenu)this.screen.getMenu()).getPossiblePaintingsSize() == 0) {
                return;
            }
            Vector2i uv = MathUtil.decisionTree(this.atlasCords(), !this.isActive(), this.isHovered());
            graphics.blit(BG_LOCATION, this.getX(), this.getY(), uv.x, uv.y, this.width, this.height);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static abstract class EaselDimensionsButton
    extends AbstractButton {
        public final int index;
        public final EaselScreen screen;

        protected abstract List<Vector2i> atlasCords();

        protected abstract int getRelevantDimension();

        public EaselDimensionsButton(int startX, int startY, int width, int height, int index, EaselScreen screen) {
            super(startX, startY, width, height, (Component)Component.empty());
            this.index = index;
            this.screen = screen;
        }

        protected void renderWidget(@NotNull GuiGraphics graphics, int p_282682_, int p_281714_, float p_282542_) {
            if (!this.screen.isEaselActive()) {
                return;
            }
            int paintingDimension = this.getRelevantDimension();
            Vector2i uv = MathUtil.decisionTree(this.atlasCords(), paintingDimension >= this.index, !this.isHovered());
            graphics.blit(BG_LOCATION, this.getX(), this.getY(), uv.x, uv.y, this.width, this.height);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
            this.defaultButtonNarrationText(output);
        }
    }
}

