/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.core.registry;

import com.dolthhaven.easeldoesit.core.EaselDoesIt;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class EaselModPaintings {
    public static final ResourceKey<PaintingVariant> CULTURE = EaselModPaintings.create("culture");
    public static final ResourceKey<PaintingVariant> HOLE = EaselModPaintings.create("hole");
    public static final ResourceKey<PaintingVariant> LAYERS = EaselModPaintings.create("layers");
    public static final ResourceKey<PaintingVariant> MONOCHROME = EaselModPaintings.create("monochrome");
    public static final ResourceKey<PaintingVariant> PORTAL = EaselModPaintings.create("portal");
    public static final ResourceKey<PaintingVariant> VINTAGE = EaselModPaintings.create("vintage");

    private static ResourceKey<PaintingVariant> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)EaselDoesIt.rl(name));
    }

    private static void register(BootstrapContext<PaintingVariant> context, ResourceKey<PaintingVariant> painting, int width, int height) {
        context.register(painting, (Object)new PaintingVariant(width, height, painting.location()));
    }

    public static void bootstrap(BootstrapContext<PaintingVariant> context) {
        EaselModPaintings.register(context, CULTURE, 1, 3);
        EaselModPaintings.register(context, HOLE, 2, 1);
        EaselModPaintings.register(context, LAYERS, 2, 3);
        EaselModPaintings.register(context, MONOCHROME, 2, 4);
        EaselModPaintings.register(context, PORTAL, 3, 2);
        EaselModPaintings.register(context, VINTAGE, 1, 1);
    }
}

