/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.other.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PaintingUtil {
    public static Optional<Holder<PaintingVariant>> readStack(ItemStack stack, HolderLookup.Provider access) {
        DataResult paintingMaybe;
        if (!stack.is(Items.PAINTING)) {
            return Optional.empty();
        }
        CustomData data = (CustomData)stack.get(DataComponents.ENTITY_DATA);
        if (data != null && (paintingMaybe = ((CustomData)stack.get(DataComponents.ENTITY_DATA)).read((DynamicOps)access.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapDecoder)Painting.VARIANT_MAP_CODEC)).isSuccess()) {
            return paintingMaybe.result();
        }
        return Optional.empty();
    }

    public static boolean isTagged(ResourceKey<PaintingVariant> painting, TagKey<PaintingVariant> tag, HolderLookup.Provider access) {
        return access.lookupOrThrow(Registries.PAINTING_VARIANT).get(tag).map(holders -> holders.stream().anyMatch(loc -> loc.is(painting))).orElse(false);
    }

    public static ItemStack makeStack(ResourceLocation location, RegistryAccess access) {
        return PaintingUtil.makeStack((PaintingVariant)((Registry)access.registry(Registries.PAINTING_VARIANT).orElseThrow()).get(location), access);
    }

    public static ItemStack makeStack(PaintingVariant variant, RegistryAccess access) {
        ItemStack paintingStack = new ItemStack((ItemLike)Items.PAINTING, 1);
        CustomData data = ((CustomData)CustomData.EMPTY.update((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)access), (MapEncoder)Painting.VARIANT_MAP_CODEC, PaintingUtil.holder(variant, access)).getOrThrow()).update(tag -> tag.putString("id", "minecraft:painting"));
        paintingStack.set(DataComponents.ENTITY_DATA, (Object)data);
        return paintingStack;
    }

    public static Set<PaintingVariant> tagged(TagKey<PaintingVariant> tag, RegistryAccess access, Predicate<PaintingVariant> predicate) {
        HashSet<PaintingVariant> variants = new HashSet<PaintingVariant>();
        ((HolderLookup.RegistryLookup)access.lookup(Registries.PAINTING_VARIANT).orElseThrow()).get(PaintingVariantTags.PLACEABLE).ifPresent(paintings -> paintings.forEach(painting -> {
            PaintingVariant variant = (PaintingVariant)painting.value();
            if (predicate.test(variant)) {
                variants.add((PaintingVariant)painting.value());
            }
        }));
        return variants;
    }

    public static Holder<PaintingVariant> holder(PaintingVariant painting, Level level) {
        return PaintingUtil.holder(painting, level.registryAccess());
    }

    public static Holder<PaintingVariant> holder(PaintingVariant painting, RegistryAccess access) {
        Optional paintings = access.registry(Registries.PAINTING_VARIANT);
        return (Holder)paintings.map(registry -> registry.getHolder(registry.getKey((Object)painting))).orElseThrow().orElseThrow();
    }
}

