/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.block;

import com.dolthhaven.easeldoesit.common.block.entity.EaselBlockEntity;
import com.dolthhaven.easeldoesit.common.inventory.EaselMenu;
import com.dolthhaven.easeldoesit.other.util.MathUtil;
import com.dolthhaven.easeldoesit.other.util.PaintingUtil;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EaselBlock
extends BaseEntityBlock {
    public static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.easel_does_it.easel");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HAS_PAINTING = BooleanProperty.m_61465_((String)"painting");
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83148_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)2.0, (double)2.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83148_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)15.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_EAST = Shapes.m_83148_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_WEST = Shapes.m_83148_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);

    public EaselBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_PAINTING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new EaselMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState superState = super.m_5573_(context);
        if (Objects.isNull(superState)) {
            return null;
        }
        return (BlockState)((BlockState)superState.m_61124_((Property)HAS_PAINTING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{HAS_PAINTING});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (EaselBlock.tryTakePainting(player, hand, level, pos)) {
            return InteractionResult.SUCCESS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(level, pos));
        player.m_36220_(Stats.f_12978_);
        return InteractionResult.CONSUME;
    }

    public static boolean tryTakePainting(Player player, InteractionHand hand, Level level, BlockPos pos) {
        EaselBlockEntity easel;
        BlockEntity entity;
        if (player.m_6144_() && player.m_21120_(hand).m_41619_() && (entity = level.m_7702_(pos)) instanceof EaselBlockEntity && !(easel = (EaselBlockEntity)entity).isEmpty()) {
            ItemStack paintingStack = easel.clearContent();
            if (!player.m_150109_().m_36054_(paintingStack)) {
                player.m_36176_(paintingStack, false);
            }
            level.m_5594_(null, pos, SoundEvents.f_12176_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean tryPlacePainting(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        if (!((Boolean)state.m_61143_((Property)HAS_PAINTING)).booleanValue()) {
            if (!level.f_46443_) {
                EaselBlock.placePainting(entity, level, pos, state, stack);
            }
            return true;
        }
        return false;
    }

    private static void placePainting(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EaselBlockEntity) {
            EaselBlockEntity easel = (EaselBlockEntity)blockEntity;
            easel.setPainting(stack.m_41620_(1));
            level.m_5594_(null, pos, SoundEvents.f_12176_, SoundSource.BLOCKS, 1.0f, 1.0f);
            EaselBlock.togglePainting(entity, pos, level, state, true);
        }
    }

    public static void togglePainting(Entity entity, BlockPos pos, Level level, BlockState state, boolean painting) {
        BlockState newState = (BlockState)state.m_61124_((Property)HAS_PAINTING, (Comparable)Boolean.valueOf(painting));
        level.m_7731_(pos, newState, 1);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)state));
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_ && !player.m_7500_()) {
            this.popPainting(state, level, pos);
        }
    }

    private void popPainting(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof EaselBlockEntity) {
            EaselBlockEntity easelEntity = (EaselBlockEntity)blockentity;
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            ItemStack itemstack = easelEntity.getPainting().m_41777_();
            float f = 0.25f * (float)direction.m_122429_();
            float f1 = 0.25f * (float)direction.m_122431_();
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5 + (double)f, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5 + (double)f1, itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
            easelEntity.clearContent();
        }
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EaselBlockEntity) {
            EaselBlockEntity easel = (EaselBlockEntity)blockEntity;
            ItemStack stack = easel.getPainting();
            if (stack.m_41619_()) {
                return 0;
            }
            Optional<PaintingVariant> maybeVariant = PaintingUtil.readStack(stack);
            if (maybeVariant.isEmpty()) {
                return 15;
            }
            PaintingVariant variant = maybeVariant.get();
            return Math.min(15, MathUtil.base4ExceptTheNumbersAre1234InsteadOf0123(variant.m_218908_() / 16, variant.m_218909_() / 16));
        }
        return 0;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new EaselBlockEntity(pos, state);
    }
}

