/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.inventory;

import com.dolthhaven.easeldoesit.core.other.EaselModTrackedData;
import com.dolthhaven.easeldoesit.core.registry.EaselModBlocks;
import com.dolthhaven.easeldoesit.core.registry.EaselModMenuTypes;
import com.dolthhaven.easeldoesit.core.registry.EaselModSoundEvents;
import com.dolthhaven.easeldoesit.other.util.MathUtil;
import com.dolthhaven.easeldoesit.other.util.PaintingUtil;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class EaselMenu
extends AbstractContainerMenu {
    private static final int MIN_DIMENSION = 16;
    private static final int MAX_DIMENSION = 64;
    private final ContainerLevelAccess access;
    long lastSoundTime;
    Runnable slotUpdateListener = () -> {};
    public final Slot inputSlot;
    public final Slot resultSlot;
    public final Container inputContainer = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            EaselMenu.this.m_6199_((Container)this);
            EaselMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();
    private final DataSlot paintingHeight = DataSlot.m_39401_();
    private final DataSlot paintingWidth = DataSlot.m_39401_();
    private final DataSlot paintingIndex = DataSlot.m_39401_();
    private final DataSlot[] savedIndexInEachDimension = new DataSlot[16];
    private List<PaintingVariant> possiblePaintings = new ArrayList<PaintingVariant>();

    public EaselMenu(int id, Inventory inv) {
        this(id, inv, ContainerLevelAccess.f_39287_);
    }

    public EaselMenu(int id, Inventory inv, final ContainerLevelAccess access) {
        super((MenuType)EaselModMenuTypes.EASEL_MENU.get(), id);
        this.access = access;
        this.inputSlot = this.m_38897_(new Slot(this.inputContainer, 0, 15, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_150930_(Items.f_42487_);
            }
        });
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
                ItemStack input = EaselMenu.this.inputSlot.m_6201_(1);
                if (!input.m_41619_()) {
                    EaselMenu.this.createResult();
                }
                access.m_39292_((level, pos) -> {
                    long l = level.m_46467_();
                    if (EaselMenu.this.lastSoundTime != l) {
                        level.m_5594_(null, pos, (SoundEvent)EaselModSoundEvents.UI_EASEL_TAKE_RESULT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        EaselMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }
        });
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        for (int i = 0; i < 16; ++i) {
            DataSlot data = DataSlot.m_39401_();
            data.m_6422_(0);
            this.savedIndexInEachDimension[i] = data;
        }
        short savedPaintingData = (Short)((IDataManager)inv.f_35978_).getValue(EaselModTrackedData.PLAYER_CURRENT_PAINTING_INDEX);
        if (savedPaintingData == 0) {
            this.setPaintingWidth(0);
            this.setPaintingHeight(0);
            this.setPaintingIndex(0);
        } else {
            int[] dataInfo = EaselModTrackedData.decodePainting(savedPaintingData);
            this.setPaintingWidth(dataInfo[0]);
            this.setPaintingHeight(dataInfo[1]);
            this.setPaintingIndex(dataInfo[2]);
        }
    }

    public void m_6199_(@NotNull Container container) {
        super.m_6199_(container);
        if (container == this.inputContainer) {
            this.createResult();
        }
    }

    private void createResult() {
        if (this.inputSlot.m_7993_().m_150930_(Items.f_42487_) && this.isLegalIndex(this.getPaintingIndex())) {
            PaintingVariant variant = this.getCurrentPainting();
            ItemStack stack = PaintingUtil.makeStack(variant);
            this.resultSlot.m_5852_(stack);
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public void dimensionChangedPre() {
        this.savePaintingForCurrentDimension();
    }

    public void dimensionChangedPost() {
        ItemStack inputStack = this.inputSlot.m_7993_();
        this.setPossiblePaintings(PaintingUtil.withTag(this.getPaintingWidth(), this.getPaintingHeight()));
        int newIndex = this.getIndexFromPaintingCoords();
        this.setPaintingIndex(newIndex);
        if (inputStack.m_150930_(Items.f_42487_)) {
            this.createResult();
        }
    }

    private int getIndexFromPaintingCoords() {
        if (!this.isLegalDimensions()) {
            return 0;
        }
        int serializedCord = this.encodeCords();
        int savedIndex = this.savedIndexInEachDimension[serializedCord].m_6501_();
        return savedIndex;
    }

    public void indexChanged() {
        this.createResult();
    }

    public List<PaintingVariant> getPossiblePaintings() {
        return this.possiblePaintings;
    }

    public void setPossiblePaintings(List<PaintingVariant> paintings) {
        this.possiblePaintings = paintings.stream().sorted(Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.PAINTING_VARIANTS).getKey(arg_0))).toList();
    }

    private void savePaintingForCurrentDimension() {
        if (!this.isLegalDimensions()) {
            return;
        }
        this.savedIndexInEachDimension[this.encodeCords()].m_6422_(this.getPaintingIndex());
    }

    public int getPaintingHeight() {
        return this.paintingHeight.m_6501_();
    }

    public int getPaintingWidth() {
        return this.paintingWidth.m_6501_();
    }

    public void setPaintingHeight(int newHeight) {
        this.dimensionChangedPre();
        this.paintingHeight.m_6422_(newHeight);
        this.dimensionChangedPost();
    }

    public void setPaintingWidth(int newWidth) {
        this.dimensionChangedPre();
        this.paintingWidth.m_6422_(newWidth);
        this.dimensionChangedPost();
    }

    public int getPossiblePaintingsSize() {
        return this.possiblePaintings.size();
    }

    public int getPaintingIndex() {
        return this.paintingIndex.m_6501_();
    }

    public void setPaintingIndex(int newIndex) {
        this.paintingIndex.m_6422_(newIndex);
    }

    public boolean isLegalIndex(int index) {
        return index >= 0 && index < this.getPossiblePaintingsSize();
    }

    private boolean isLegalDimensions() {
        if (this.getPaintingHeight() < 16 || this.getPaintingHeight() > 64) {
            return false;
        }
        return this.getPaintingWidth() >= 16 && this.getPaintingWidth() <= 64;
    }

    public PaintingVariant getCurrentPainting() {
        try {
            return this.getPossiblePaintings().get(this.getPaintingIndex());
        }
        catch (IndexOutOfBoundsException e) {
            return (PaintingVariant)ForgeRegistries.PAINTING_VARIANTS.getValue(PaintingVariants.f_218914_.m_135782_());
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack input = slot.m_7993_();
        Item item = input.m_41720_();
        ItemStack inputCopy = input.m_41777_();
        if (index == this.inputSlot.getSlotIndex()) {
            item.m_7836_(input, player.m_9236_(), player);
            if (!this.m_38903_(input, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(input, inputCopy);
        } else if (index == this.resultSlot.getSlotIndex() ? !this.m_38903_(input, 2, 38, true) : (input.m_150930_(Items.f_42487_) ? !this.m_38903_(input, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(input, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(input, 2, 29, false)))) {
            return ItemStack.f_41583_;
        }
        if (input.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        slot.m_6654_();
        if (input.m_41613_() == inputCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, input);
        this.m_38946_();
        return inputCopy;
    }

    public boolean m_6875_(@NotNull Player player) {
        return EaselMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)EaselModBlocks.EASEL.get()));
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    private int encodeCords() {
        return EaselMenu.encodeTuple(this.getPaintingWidth() / 16, this.getPaintingHeight() / 16);
    }

    private static int encodeTuple(int width, int height) {
        return MathUtil.base4ExceptTheNumbersAre1234InsteadOf0123(width, height);
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return (MenuType)EaselModMenuTypes.EASEL_MENU.get();
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(player, this.inputContainer));
        this.savePainting(player);
    }

    private void savePainting(@NotNull Player player) {
        if (!this.isLegalDimensions()) {
            return;
        }
        IDataManager manager = (IDataManager)player;
        short paintingIndex = EaselModTrackedData.encodePainting(new int[]{this.getPaintingWidth() / 16 - 1, this.getPaintingHeight() / 16 - 1, this.getPaintingIndex()});
        manager.setValue(EaselModTrackedData.PLAYER_CURRENT_PAINTING_INDEX, (Object)paintingIndex);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int invRow = 0; invRow < 3; ++invRow) {
            for (int invCol = 0; invCol < 9; ++invCol) {
                this.m_38897_(new Slot((Container)playerInventory, invCol + invRow * 9 + 9, 8 + invCol * 18, 84 + invRow * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }
}

