/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.core;

import com.dolthhaven.easeldoesit.common.network.EaselModPacketListener;
import com.dolthhaven.easeldoesit.core.EaselModConfig;
import com.dolthhaven.easeldoesit.core.other.EaselModCompat;
import com.dolthhaven.easeldoesit.core.other.EaselModTrackedData;
import com.dolthhaven.easeldoesit.core.registry.EaselModBlocks;
import com.dolthhaven.easeldoesit.core.registry.EaselModItems;
import com.dolthhaven.easeldoesit.core.registry.EaselModMenuTypes;
import com.dolthhaven.easeldoesit.core.registry.EaselModPaintings;
import com.dolthhaven.easeldoesit.core.registry.EaselModVillagers;
import com.dolthhaven.easeldoesit.core.registry.other.EaselModRecipeSerializers;
import com.dolthhaven.easeldoesit.data.client.EaselModBlockStates;
import com.dolthhaven.easeldoesit.data.client.EaselModSoundProvider;
import com.dolthhaven.easeldoesit.data.server.EaselModLootTables;
import com.dolthhaven.easeldoesit.data.server.EaselModRecipes;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModBlockTags;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModItemTags;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModPaintingTags;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModPoiTags;
import com.mojang.logging.LogUtils;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="easel_does_it")
public class EaselDoesIt {
    public static final String MOD_ID = "easel_does_it";
    public static final String GIT_URL = "https://github.com/thelegitdolt/easel-does-it";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("easel_does_it");
    private static final Logger LOGGER = LogUtils.getLogger();

    public EaselDoesIt() {
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        EaselModMenuTypes.MENUS.register(bus);
        EaselModPaintings.PAINTING_VARIANTS.register(bus);
        EaselModVillagers.POI_TYPES.register(bus);
        EaselModRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        EaselModVillagers.VILLAGER_PROFESSIONS.register(bus);
        EaselModTrackedData.registerTrackedData();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EaselModConfig.COMMON_SPEC);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            EaselModCompat.doCompat();
            EaselModPacketListener.register();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            EaselModBlocks.setUpTabEditors();
            EaselModItems.setUpTabEditors();
            EaselModMenuTypes.registerScreens();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator dataGen = event.getGenerator();
        boolean server = event.includeServer();
        EaselModBlockTags easelModBlockTags = new EaselModBlockTags(event);
        dataGen.addProvider(server, (DataProvider)easelModBlockTags);
        dataGen.addProvider(server, (DataProvider)new EaselModItemTags(event, easelModBlockTags.m_274426_()));
        dataGen.addProvider(server, (DataProvider)new EaselModPoiTags(event));
        dataGen.addProvider(server, (DataProvider)new EaselModPaintingTags(event));
        dataGen.addProvider(server, (DataProvider)new EaselModLootTables(event));
        dataGen.addProvider(server, (DataProvider)new EaselModRecipes(event));
        boolean client = event.includeClient();
        dataGen.addProvider(client, (DataProvider)new EaselModBlockStates(event));
        dataGen.addProvider(client, (DataProvider)new EaselModSoundProvider(event));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static void log(String str) {
        LOGGER.info(str);
    }

    @Mod.EventBusSubscriber(modid="easel_does_it", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

