/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.inventory;

import com.dolthhaven.easeldoesit.common.inventory.EaselMenu;
import com.dolthhaven.easeldoesit.common.network.EaselModPacketListener;
import com.dolthhaven.easeldoesit.common.network.packets.C2SSetEaselPaintingHeightPacket;
import com.dolthhaven.easeldoesit.common.network.packets.C2SSetEaselPaintingIndexPacket;
import com.dolthhaven.easeldoesit.common.network.packets.C2SSetEaselPaintingWidthPacket;
import com.dolthhaven.easeldoesit.core.EaselDoesIt;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EaselScreen
extends AbstractContainerScreen<EaselMenu> {
    private static final ResourceLocation BG_LOCATION = EaselDoesIt.rl("textures/gui/container/easel.png");
    private static final byte SCROLL_THRESHOLD = 30;
    private final int imageWidth;
    private final int imageHeight;
    private int leftPos;
    private int topPos;
    private float untilNextScroll = 0.0f;
    private final EaselWidthButton[] paintingWidthButtons = new EaselWidthButton[4];
    private final EaselHeightsButton[] paintingHeightButtons = new EaselHeightsButton[4];
    private final EaselPickerButton[] paintingPickers = new EaselPickerButton[2];
    private static final int MAX_PAINTINGS_PER_PAGE = 8;
    private static final int AVAILABLE_PIXELS_PER_PAGE = 51;
    private static final int PAGES_START_X = 126;
    private static final int PAGE_BUTTON_X = 181;
    private static final int PAGE_BUTTON_Y = 23;
    private static final int PAGE_BUTTON_SELECTED_X = 176;
    private static final int PAGE_BUTTON_SELECTED_Y = 23;
    private static final int PAGE_BUTTON_DIMENSIONS = 5;
    private static final int PAGE_BUTTONS_START = 21;
    private static final int BUTTONS_DIMENSIONS_LONG = 16;
    private static final int BUTTONS_DIMENSIONS_SHORT = 7;
    private static final int HEIGHT_BUTTONS_START_X = 48;
    private static final int HEIGHT_BUTTONS_START_Y = 14;
    private static final int WIDTH_BUTTONS_START_X = 56;
    private static final int WIDTH_BUTTONS_START_Y = 6;
    private static final int PICKER_X = 123;
    private static final int PICKER_TOP_Y = 14;
    private static final int PICKER_BOTTOM_Y = 72;
    private static final int PICKER_X_DIMENSION = 11;
    private static final int PICKER_Y_DIMENSION = 7;
    private static final int PICKER_ATLAS_Y = 28;
    private static final int PICKER_BOTTOM_ATLAS_X = 176;
    private static final int PICKER_TOP_ATLAS_X = 187;
    private static final int PICKER_BOTTOM_HOVERED_ATLAS_X = 198;
    private static final int PICKER_TOP_HOVERED_ATLAS_X = 209;
    private static final int PICKER_BOTTOM_INACTIVE_ATLAS_X = 220;
    private static final int PICKER_TOP_INACTIVE_ATLAS_X = 231;
    private static final int PREVIEW_BOX_X = 56;
    private static final int PREVIEW_BOX_Y = 14;
    private static final int PREVIEW_BOX_ATLAS_X = 176;
    private static final int PREVIEW_BOX_ATLAS_Y = 35;
    private static final int PREVIEW_BOX_DIMENSIONS = 64;
    private static final int WIDTH_BUTTON_NOT_CLICKED_ATLAS_CORDS_X = 183;
    private static final int WIDTH_BUTTON_NOT_CLICKED_ATLAS_CORDS_Y = 0;
    private static final int HEIGHT_BUTTON_NOT_CLICKED_ATLAS_CORDS_X = 192;
    private static final int HEIGHT_BUTTON_NOT_CLICKED_ATLAS_CORDS_Y = 7;
    private static final int WIDTH_BUTTON_CLICKED_ATLAS_CORDS_X = 176;
    private static final int WIDTH_BUTTON_CLICKED_ATLAS_CORDS_Y = 16;
    private static final int HEIGHT_BUTTON_CLICKED_ATLAS_CORDS_X = 176;
    private static final int HEIGHT_BUTTON_CLICKED_ATLAS_CORDS_Y = 0;
    private static final int WIDTH_BUTTON_HOVERED_X = 206;
    private static final int WIDTH_BUTTON_HOVERED_Y = 0;
    private static final int HEIGHT_BUTTON_HOVERED_X = 199;
    private static final int HEIGHT_BUTTON_HOVERED_Y = 0;

    public EaselScreen(EaselMenu menu, Inventory inv, Component component) {
        super((AbstractContainerMenu)menu, inv, component);
        ((EaselMenu)this.f_97732_).registerUpdateListener(this::containerChanged);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.f_97731_ = 1000;
        this.addHeightButtons();
        this.addWidthButtons();
        this.addPickers();
    }

    private void addWidthButtons() {
        for (int i = 1; i <= 4; ++i) {
            EaselWidthButton button = new EaselWidthButton(this.leftPos + 56 + 16 * (i - 1), this.topPos + 6, i);
            button.f_93623_ = false;
            this.m_142416_((GuiEventListener)button);
            this.paintingWidthButtons[i - 1] = button;
        }
    }

    private void addHeightButtons() {
        for (int i = 1; i <= 4; ++i) {
            EaselHeightsButton button = new EaselHeightsButton(this.leftPos + 48, this.topPos + 14 + 16 * (i - 1), i);
            button.f_93623_ = false;
            this.m_142416_((GuiEventListener)button);
            this.paintingHeightButtons[i - 1] = button;
        }
    }

    private void addPickers() {
        EaselPickerButton topPicker = new EaselPickerButton(this.leftPos + 123, this.topPos + 14, this){

            @Override
            int affectIndex(int oldIndex) {
                return oldIndex - 1;
            }

            @Override
            int[] getTextureAtlasCords() {
                return new int[]{187, 28, 209, 28, 231, 28};
            }
        };
        EaselPickerButton bottomPicker = new EaselPickerButton(this.leftPos + 123, this.topPos + 72, this){

            @Override
            int affectIndex(int oldIndex) {
                return oldIndex + 1;
            }

            @Override
            int[] getTextureAtlasCords() {
                return new int[]{176, 28, 198, 28, 220, 28};
            }
        };
        topPicker.f_93623_ = false;
        bottomPicker.f_93623_ = false;
        this.paintingPickers[0] = topPicker;
        this.paintingPickers[1] = bottomPicker;
        this.m_142416_((GuiEventListener)topPicker);
        this.m_142416_((GuiEventListener)bottomPicker);
    }

    private void containerChanged() {
        if (this.isEaselActive()) {
            for (EaselHeightsButton easelHeightsButton : this.paintingHeightButtons) {
                easelHeightsButton.f_93623_ = true;
            }
            for (EaselDimensionsButton easelDimensionsButton : this.paintingWidthButtons) {
                easelDimensionsButton.f_93623_ = true;
            }
            for (AbstractButton abstractButton : this.paintingPickers) {
                if (!abstractButton.canBePressed(((EaselMenu)this.f_97732_).getPaintingIndex())) continue;
                abstractButton.f_93623_ = true;
            }
        } else {
            for (EaselHeightsButton easelHeightsButton : this.paintingHeightButtons) {
                easelHeightsButton.f_93623_ = false;
            }
            for (EaselDimensionsButton easelDimensionsButton : this.paintingWidthButtons) {
                easelDimensionsButton.f_93623_ = false;
            }
            for (AbstractButton abstractButton : this.paintingPickers) {
                abstractButton.f_93623_ = false;
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double speed) {
        double potentialIndex = this.subtractInputFromScroll(speed);
        float remainders = (float)potentialIndex - (float)Mth.m_14107_((double)potentialIndex);
        this.untilNextScroll += remainders;
        if (this.untilNextScroll > 1.0f) {
            this.untilNextScroll -= 1.0f;
            potentialIndex += 1.0;
        }
        this.setMenuIndex(Mth.m_14107_((double)potentialIndex));
        return true;
    }

    protected double subtractInputFromScroll(double pInput) {
        Double2DoubleFunction scrollFunc = dub -> {
            double thresh;
            int sign = dub < 0.0 ? -1 : 1;
            double absDub = Math.abs(dub);
            if (absDub < (thresh = 3.2)) {
                return thresh * (double)sign;
            }
            return (thresh + thresh + absDub) / 3.0 * (double)sign;
        };
        pInput = (Double)scrollFunc.apply((Object)pInput);
        double multiplier = 1.1;
        double divide = (double)((EaselMenu)this.f_97732_).getPossiblePaintingsSize() * multiplier;
        return Mth.m_14008_((double)((double)((EaselMenu)this.f_97732_).getPaintingIndex() - pInput / divide), (double)0.0, (double)(((EaselMenu)this.f_97732_).getPossiblePaintingsSize() - 1));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_LOCATION);
        graphics.m_280218_(BG_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderPaintingGrid(graphics);
        this.renderPainting(graphics);
        this.renderPageManager(graphics);
    }

    private void renderDebugString(GuiGraphics graphics) {
        graphics.m_280488_(this.f_96547_, ((EaselMenu)this.f_97732_).getPaintingWidth() + ", " + ((EaselMenu)this.f_97732_).getPaintingHeight() + " Painting index: " + ((EaselMenu)this.f_97732_).getPaintingIndex(), 0, 0, 0xFFFFFF);
    }

    private void renderPaintingGrid(GuiGraphics graphics) {
        if (this.isEaselActive()) {
            graphics.m_280218_(BG_LOCATION, this.leftPos + 56, this.topPos + 14, 176, 35, 64, 64);
        }
    }

    private void renderPageManager(GuiGraphics graphics) {
        if (!this.isEaselActive()) {
            return;
        }
        int menuPaintingIndex = ((EaselMenu)this.m_6262_()).getPaintingIndex();
        int currentPage = Mth.m_14165_((double)((double)(menuPaintingIndex + 1) / 8.0));
        int numPaintingsInThisPage = Math.min(8, ((EaselMenu)this.m_6262_()).getPossiblePaintingsSize() - 8 * (currentPage - 1));
        for (int[] yPosAndIndex : this.getPageButtonYPositionsAndRepresentedIndex(currentPage, numPaintingsInThisPage)) {
            int dotYLoc;
            int dotXLoc;
            int yPos = yPosAndIndex[0];
            int currentIndex = yPosAndIndex[1];
            if (currentIndex == menuPaintingIndex) {
                dotXLoc = 176;
                dotYLoc = 23;
            } else {
                dotXLoc = 181;
                dotYLoc = 23;
            }
            graphics.m_280218_(BG_LOCATION, this.leftPos + 126, this.topPos + yPos, dotXLoc, dotYLoc, 5, 5);
        }
    }

    private List<int[]> getPageButtonYPositionsAndRepresentedIndex(int currentPage, int numPaintingsInThisPage) {
        ArrayList list = Lists.newArrayList();
        int yPos = (51 - this.totalReqPixelsFor(numPaintingsInThisPage)) / 2;
        yPos += 2;
        for (int i = 0; i < numPaintingsInThisPage; ++i) {
            list.add(new int[]{yPos + 21, (currentPage - 1) * 8 + i});
            yPos += 6;
        }
        return list;
    }

    private int totalReqPixelsFor(int numPaintingsInPage) {
        return numPaintingsInPage * 6 + 3;
    }

    private void renderPainting(GuiGraphics graphics) {
        if (!this.isEaselActive()) {
            return;
        }
        if (((EaselMenu)this.f_97732_).getPossiblePaintingsSize() == 0) {
            return;
        }
        PaintingVariant currentPainting = ((EaselMenu)this.f_97732_).getCurrentPainting();
        TextureAtlasSprite paintingSprite = Minecraft.m_91087_().m_91305_().m_235033_(currentPainting);
        graphics.m_280159_(this.leftPos + 56, this.topPos + 14, 0, currentPainting.m_218908_(), currentPainting.m_218909_(), paintingSprite);
    }

    private boolean isEaselActive() {
        return ((EaselMenu)this.m_6262_()).inputSlot.m_7993_().m_150930_(Items.f_42487_);
    }

    private void setMenuPaintingWidth(int newWidth) {
        ((EaselMenu)this.f_97732_).setPaintingWidth(newWidth);
        EaselModPacketListener.sendToServer(new C2SSetEaselPaintingWidthPacket((byte)newWidth));
        this.updatePickers(((EaselMenu)this.f_97732_).getPaintingIndex());
    }

    private void setMenuPaintingHeight(int newHeight) {
        ((EaselMenu)this.f_97732_).setPaintingHeight(newHeight);
        EaselModPacketListener.sendToServer(new C2SSetEaselPaintingHeightPacket((byte)newHeight));
        this.updatePickers(((EaselMenu)this.f_97732_).getPaintingIndex());
    }

    private void setMenuIndex(int newIndex) {
        ((EaselMenu)this.f_97732_).setPaintingIndex(newIndex);
        EaselModPacketListener.sendToServer(new C2SSetEaselPaintingIndexPacket((short)newIndex));
        this.updatePickers(newIndex);
    }

    private void updatePickers(int newIndex) {
        for (EaselPickerButton button : this.paintingPickers) {
            button.f_93623_ = button.canBePressed(newIndex);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class EaselWidthButton
    extends EaselDimensionsButton {
        public EaselWidthButton(int startX, int startY, int index) {
            super(startX, startY, 16, 7, index, EaselScreen.this);
        }

        public void m_5691_() {
            ((EaselMenu)EaselScreen.this.m_6262_()).dimensionChangedPre();
            int newWidth = this.index * 16;
            EaselScreen.this.setMenuPaintingWidth(newWidth);
            ((EaselMenu)EaselScreen.this.m_6262_()).dimensionChangedPost();
        }

        @Override
        protected int[] getAtlasPositionsForButtons() {
            return new int[]{176, 16, 183, 0, 206, 0};
        }

        @Override
        protected int getRelevantDimension() {
            return ((EaselMenu)EaselScreen.this.m_6262_()).getPaintingWidth();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class EaselHeightsButton
    extends EaselDimensionsButton {
        public EaselHeightsButton(int startX, int startY, int index) {
            super(startX, startY, 7, 16, index, EaselScreen.this);
        }

        public void m_5691_() {
            ((EaselMenu)EaselScreen.this.m_6262_()).dimensionChangedPre();
            int newHeights = this.index * 16;
            EaselScreen.this.setMenuPaintingHeight(newHeights);
            ((EaselMenu)EaselScreen.this.m_6262_()).dimensionChangedPost();
        }

        @Override
        protected int[] getAtlasPositionsForButtons() {
            return new int[]{176, 0, 192, 7, 199, 0};
        }

        @Override
        protected int getRelevantDimension() {
            return ((EaselMenu)EaselScreen.this.m_6262_()).getPaintingHeight();
        }
    }

    private static abstract class EaselPickerButton
    extends AbstractButton {
        private final EaselScreen screen;

        public EaselPickerButton(int startX, int startY, EaselScreen screen) {
            super(startX, startY, 11, 7, CommonComponents.f_237098_);
            this.screen = screen;
            this.f_93623_ = false;
        }

        protected void m_168797_(@NotNull NarrationElementOutput output) {
            this.m_168802_(output);
        }

        abstract int affectIndex(int var1);

        abstract int[] getTextureAtlasCords();

        public void m_5691_() {
            int paintingIndex = ((EaselMenu)this.screen.m_6262_()).getPaintingIndex();
            int newIndex = this.affectIndex(paintingIndex);
            if (this.canBePressed(paintingIndex)) {
                this.screen.setMenuIndex(newIndex);
            }
        }

        public boolean canBePressed(int index) {
            return ((EaselMenu)this.screen.m_6262_()).isLegalIndex(this.affectIndex(index));
        }

        protected void m_87963_(@NotNull GuiGraphics graphics, int p_282682_, int p_281714_, float p_282542_) {
            int atlasYCord;
            int atlasXCord;
            if (!this.screen.isEaselActive()) {
                return;
            }
            if (((EaselMenu)this.screen.m_6262_()).getPossiblePaintingsSize() == 0) {
                return;
            }
            if (!this.m_142518_()) {
                atlasXCord = this.getTextureAtlasCords()[4];
                atlasYCord = this.getTextureAtlasCords()[5];
            } else if (this.m_274382_()) {
                atlasXCord = this.getTextureAtlasCords()[2];
                atlasYCord = this.getTextureAtlasCords()[3];
            } else {
                atlasXCord = this.getTextureAtlasCords()[0];
                atlasYCord = this.getTextureAtlasCords()[1];
            }
            graphics.m_280218_(BG_LOCATION, this.m_252754_(), this.m_252907_(), atlasXCord, atlasYCord, this.f_93618_, this.f_93619_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static abstract class EaselDimensionsButton
    extends AbstractButton {
        public final int index;
        public final EaselScreen screen;

        protected abstract int[] getAtlasPositionsForButtons();

        protected abstract int getRelevantDimension();

        public EaselDimensionsButton(int startX, int startY, int width, int height, int index, EaselScreen screen) {
            super(startX, startY, width, height, (Component)Component.m_237119_());
            this.index = index;
            this.screen = screen;
        }

        protected void m_87963_(@NotNull GuiGraphics graphics, int p_282682_, int p_281714_, float p_282542_) {
            int buttonToRenderY;
            int buttonToRenderX;
            if (!this.screen.isEaselActive()) {
                return;
            }
            int paintingDimension = this.getRelevantDimension() / 16;
            if (paintingDimension >= this.index) {
                buttonToRenderX = this.getAtlasPositionsForButtons()[0];
                buttonToRenderY = this.getAtlasPositionsForButtons()[1];
            } else if (!this.m_274382_()) {
                buttonToRenderX = this.getAtlasPositionsForButtons()[2];
                buttonToRenderY = this.getAtlasPositionsForButtons()[3];
            } else {
                buttonToRenderX = this.getAtlasPositionsForButtons()[4];
                buttonToRenderY = this.getAtlasPositionsForButtons()[5];
            }
            graphics.m_280218_(BG_LOCATION, this.m_252754_(), this.m_252907_(), buttonToRenderX, buttonToRenderY, this.f_93618_, this.f_93619_);
        }

        protected void m_168797_(@NotNull NarrationElementOutput output) {
            this.m_168802_(output);
        }
    }
}

