/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.villagers;

import com.dolthhaven.easeldoesit.other.util.PaintingUtil;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EaselModItemListings {

    public static class EitherOrTrade
    implements VillagerTrades.ItemListing {
        private final VillagerTrades.ItemListing tradeOne;
        private final VillagerTrades.ItemListing tradeTwo;

        public EitherOrTrade(VillagerTrades.ItemListing tradeOne, VillagerTrades.ItemListing tradeTwo) {
            this.tradeOne = tradeOne;
            this.tradeTwo = tradeTwo;
        }

        @Nullable
        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource random) {
            return random.m_188499_() ? this.tradeOne.m_213663_(entity, random) : this.tradeTwo.m_213663_(entity, random);
        }
    }

    public static class SellPaintingVariantTrade
    implements VillagerTrades.ItemListing {
        private final PaintingVariant variant;
        private final UniformInt emeraldCost;
        private final int maxUses;

        public SellPaintingVariantTrade(PaintingVariant variant, UniformInt emeraldCost, int maxUses) {
            this.variant = variant;
            this.emeraldCost = emeraldCost;
            this.maxUses = maxUses;
        }

        @Nullable
        public MerchantOffer m_213663_(@NotNull Entity p_219693_, @NotNull RandomSource p_219694_) {
            ItemStack paintingStack = PaintingUtil.makeStack(this.variant);
            ItemStack emeraldStack = new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost.m_214085_(p_219694_));
            return new MerchantOffer(emeraldStack, paintingStack, this.maxUses, 25, 0.01f);
        }
    }

    public static class RandomItemsSellingTrade
    implements VillagerTrades.ItemListing {
        private final UniformInt emeraldCount;
        private final List<Item> allowedItems;
        private final UniformInt costCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public RandomItemsSellingTrade(UniformInt emeraldCount, List<Item> allowedItems, UniformInt costCount, int maxUses, int xp, float priceMultiplier) {
            this.emeraldCount = emeraldCount;
            this.allowedItems = allowedItems;
            this.costCount = costCount;
            this.maxUses = maxUses;
            this.villagerXp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public RandomItemsSellingTrade(List<Item> allowedItems, UniformInt costCount, UniformInt emeraldCount) {
            this(emeraldCount, allowedItems, costCount, 16, 2, 0.05f);
        }

        @Nullable
        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource source) {
            Item item = this.allowedItems.get(source.m_188503_(this.allowedItems.size()));
            int cost = this.costCount.m_214085_(source);
            int emerald = this.emeraldCount.m_214085_(source);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, emerald), new ItemStack((ItemLike)item, cost), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class RandomItemsBuyingTrade
    implements VillagerTrades.ItemListing {
        private final List<Item> allowedItems;
        private final UniformInt costCount;
        private final UniformInt emeraldCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public RandomItemsBuyingTrade(List<Item> allowedItems, UniformInt costCount, UniformInt emeraldCount, int maxUses, int xp, float priceMultiplier) {
            this.allowedItems = allowedItems;
            this.costCount = costCount;
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.villagerXp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public RandomItemsBuyingTrade(List<Item> allowedItems, UniformInt costCount, UniformInt emeraldCount) {
            this(allowedItems, costCount, emeraldCount, 16, 2, 0.05f);
        }

        @Nullable
        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource source) {
            Item item = this.allowedItems.get(source.m_188503_(this.allowedItems.size()));
            int cost = this.costCount.m_214085_(source);
            int emerald = this.emeraldCount.m_214085_(source);
            return new MerchantOffer(new ItemStack((ItemLike)item, cost), new ItemStack((ItemLike)Items.f_42616_, emerald), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class ItemSellingTrade
    implements VillagerTrades.ItemListing {
        private final Item boughtItem;
        private final UniformInt costCount;
        private final UniformInt emeraldCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemSellingTrade(Item soldItem, UniformInt costCount, UniformInt emeraldCount, int maxUses, int villagerXp, float priceMultiplier) {
            this.boughtItem = soldItem;
            this.costCount = costCount;
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
        }

        @Nullable
        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource random) {
            int cost = this.costCount.m_214085_(random);
            int emerald = this.emeraldCount.m_214085_(random);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, emerald), new ItemStack((ItemLike)this.boughtItem, cost), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class ItemBuyingTrade
    implements VillagerTrades.ItemListing {
        private final Item boughtItem;
        private final UniformInt costCount;
        private final UniformInt emeraldCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemBuyingTrade(Item boughtItem, UniformInt costCount, UniformInt emeraldCount, int maxUses, int villagerXp, float priceMultiplier) {
            this.boughtItem = boughtItem;
            this.costCount = costCount;
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
        }

        public ItemBuyingTrade(ResourceLocation itemRl, UniformInt costCount, UniformInt emeraldCount, int maxUses, int villagerXp, float priceMultiplier) {
            this((Item)ForgeRegistries.ITEMS.getValue(itemRl), costCount, emeraldCount, maxUses, villagerXp, priceMultiplier);
        }

        @Nullable
        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource random) {
            int cost = this.costCount.m_214085_(random);
            int emerald = this.emeraldCount.m_214085_(random);
            return new MerchantOffer(new ItemStack((ItemLike)this.boughtItem, cost), new ItemStack((ItemLike)Items.f_42616_, emerald), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

