/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.data.client;

import com.dolthhaven.easeldoesit.core.EaselDoesIt;
import com.dolthhaven.easeldoesit.core.registry.EaselModBlocks;
import com.dolthhaven.easeldoesit.core.registry.EaselModSoundEvents;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class EaselModSoundProvider
extends SoundDefinitionsProvider {
    public EaselModSoundProvider(GatherDataEvent e) {
        super(e.getGenerator().getPackOutput(), "easel_does_it", e.getExistingFileHelper());
    }

    public void registerSounds() {
        this.register("ui/easel/draw1", EaselModSoundProvider.getUISubtitle(EaselModBlocks.EASEL, "draw_painting"), null);
    }

    private void register(String location, @Nullable String subtitle, Consumer<SoundDefinition.Sound> consumer) {
        SoundDefinition.Sound sound = EaselModSoundProvider.sound((ResourceLocation)EaselDoesIt.REGISTRY_HELPER.prefix(location));
        if (consumer != null) {
            consumer.accept(sound);
        }
        this.add((SoundEvent)EaselModSoundEvents.UI_EASEL_TAKE_RESULT.get(), EaselModSoundProvider.definition().with(sound).subtitle(subtitle));
    }

    public static String getUISubtitle(RegistryObject<Block> block, String action) {
        return "subtitle.ui." + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get()))).toString().replace(':', '.') + "." + action;
    }
}

