/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.core;

import com.dolthhaven.easeldoesit.core.other.EaselModTrackedData;
import com.dolthhaven.easeldoesit.core.registry.EaselModBlockEntities;
import com.dolthhaven.easeldoesit.core.registry.EaselModBlocks;
import com.dolthhaven.easeldoesit.core.registry.EaselModItems;
import com.dolthhaven.easeldoesit.core.registry.EaselModMenuTypes;
import com.dolthhaven.easeldoesit.core.registry.EaselModSoundEvents;
import com.dolthhaven.easeldoesit.core.registry.EaselModVillagers;
import com.dolthhaven.easeldoesit.core.registry.other.EaselModRecipeSerializers;
import com.dolthhaven.easeldoesit.data.client.EaselModBlockStates;
import com.dolthhaven.easeldoesit.data.client.EaselModSoundProvider;
import com.dolthhaven.easeldoesit.data.server.EaselModDataMaps;
import com.dolthhaven.easeldoesit.data.server.EaselModDataRegistries;
import com.dolthhaven.easeldoesit.data.server.EaselModLootTables;
import com.dolthhaven.easeldoesit.data.server.EaselModRecipes;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModBlockTags;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModItemTags;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModPaintingTags;
import com.dolthhaven.easeldoesit.data.server.tags.EaselModPoiTags;
import com.mojang.logging.LogUtils;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.slf4j.Logger;

@Mod(value="easel_does_it")
public class EaselDoesIt {
    public static final String MOD_ID = "easel_does_it";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("easel_does_it");
    private static final Logger LOGGER = LogUtils.getLogger();

    public EaselDoesIt(IEventBus bus, ModContainer container) {
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        EaselModItems.ITEMS.register(bus);
        EaselModBlocks.BLOCKS.register(bus);
        EaselModBlockEntities.BLOCK_ENTITIES.register(bus);
        EaselModSoundEvents.SOUND_EVENTS.register(bus);
        EaselModMenuTypes.MENUS.register(bus);
        EaselModVillagers.POI_TYPES.register(bus);
        EaselModRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        EaselModVillagers.VILLAGER_PROFESSIONS.register(bus);
        EaselModTrackedData.registerTrackedData();
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            EaselModBlocks.setUpTabEditors();
            EaselModItems.setUpTabEditors();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator dataGen = event.getGenerator();
        boolean server = event.includeServer();
        EaselModDataRegistries dataRegistries = new EaselModDataRegistries(event);
        dataGen.addProvider(server, (DataProvider)dataRegistries);
        CompletableFuture provider = dataRegistries.getRegistryProvider();
        EaselModBlockTags easelModBlockTags = new EaselModBlockTags(event);
        dataGen.addProvider(server, (DataProvider)easelModBlockTags);
        dataGen.addProvider(server, (DataProvider)new EaselModItemTags(event, easelModBlockTags.contentsGetter()));
        dataGen.addProvider(server, (DataProvider)new EaselModPoiTags(event));
        dataGen.addProvider(server, (DataProvider)new EaselModPaintingTags(event, provider));
        dataGen.addProvider(server, (DataProvider)new EaselModLootTables(event));
        dataGen.addProvider(server, (DataProvider)new EaselModRecipes(event));
        dataGen.addProvider(server, (DataProvider)new EaselModDataMaps(event));
        boolean client = event.includeClient();
        dataGen.addProvider(client, (DataProvider)new EaselModBlockStates(event));
        dataGen.addProvider(client, (DataProvider)new EaselModSoundProvider(event));
    }

    public static void log(String str) {
        LOGGER.info(str);
    }

    public static void warnLog(String str) {
        LOGGER.warn(str);
    }
}

