/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.other.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.fml.ModList;

public class ModUtil {
    public static List<Item> getAllMembersOfTag(TagKey<Item> tag) {
        return BuiltInRegistries.ITEM.entrySet().stream().map(Map.Entry::getValue).filter(item -> item.builtInRegistryHolder().is(tag)).toList();
    }

    public static List<Item> getAllDyedItems(Function<String, ResourceLocation> thing) {
        if (!ModList.get().isLoaded("dye_depot")) {
            return Arrays.stream(DyeColor.values()).map(dye -> (Item)BuiltInRegistries.ITEM.get((ResourceLocation)thing.apply(dye.getName()))).toList();
        }
        return Arrays.stream(DyeColor.values()).map(dye -> (ResourceLocation)thing.apply(dye.getName())).map(ModUtil::tryModIds).filter(item -> item != Items.AIR).toList();
    }

    private static Item tryModIds(ResourceLocation location) {
        for (String i : new String[]{"minecraft", "dye_depot", "dye_the_world"}) {
            Item item = (Item)BuiltInRegistries.ITEM.get(location = ResourceLocation.fromNamespaceAndPath((String)i, (String)location.getPath()));
            if (item == Items.AIR) continue;
            return item;
        }
        return Items.AIR;
    }
}

