/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks;

import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.motschen.rocks.block.NetherGeyser;
import eu.midnightdust.motschen.rocks.block.OverworldGeyser;
import eu.midnightdust.motschen.rocks.block.Pinecone;
import eu.midnightdust.motschen.rocks.block.Rock;
import eu.midnightdust.motschen.rocks.block.Seashell;
import eu.midnightdust.motschen.rocks.block.Starfish;
import eu.midnightdust.motschen.rocks.block.Stick;
import eu.midnightdust.motschen.rocks.block.blockentity.BlockEntityInit;
import eu.midnightdust.motschen.rocks.blockstates.RockVariation;
import eu.midnightdust.motschen.rocks.blockstates.SeashellVariation;
import eu.midnightdust.motschen.rocks.blockstates.StarfishVariation;
import eu.midnightdust.motschen.rocks.blockstates.StickVariation;
import eu.midnightdust.motschen.rocks.config.RocksConfig;
import eu.midnightdust.motschen.rocks.networking.HelloPayload;
import eu.midnightdust.motschen.rocks.util.RegistryUtil;
import eu.midnightdust.motschen.rocks.util.RockType;
import eu.midnightdust.motschen.rocks.util.StickType;
import eu.midnightdust.motschen.rocks.util.polymer.PolyUtil;
import eu.midnightdust.motschen.rocks.world.FeatureInjector;
import eu.midnightdust.motschen.rocks.world.FeatureRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RocksMain
implements ModInitializer {
    public static final String MOD_ID = "rocks";
    public static boolean polymerMode = RocksMain.hasRequiredPolymerModules();
    public static List<class_3222> playersWithMod = new ArrayList<class_3222>();
    public static final class_2754<RockVariation> ROCK_VARIATION = class_2754.method_11850((String)"variation", RockVariation.class);
    public static final class_2754<StickVariation> STICK_VARIATION = class_2754.method_11850((String)"variation", StickVariation.class);
    public static final class_2754<SeashellVariation> SEASHELL_VARIATION = class_2754.method_11850((String)"variation", SeashellVariation.class);
    public static final class_2754<StarfishVariation> STARFISH_VARIATION = class_2754.method_11850((String)"variation", StarfishVariation.class);
    public static Map<RockType, Rock> rocksByType = new HashMap<RockType, Rock>();
    public static Map<StickType, Stick> sticksByType = new HashMap<StickType, Stick>();
    public static Map<RockType, class_1792> splittersByType = new HashMap<RockType, class_1792>();
    public static final class_2960 PINECONE = RocksMain.id("pinecone");
    public static final class_2960 SEASHELL = RocksMain.id("seashell");
    public static final class_2960 STARFISH = RocksMain.id("starfish");
    public static final class_2960 GEYSER = RocksMain.id("geyser");
    public static final class_2960 NETHER_GEYSER = RocksMain.id("nether_geyser");
    public static class_2248 Pinecone;
    public static class_2248 Seashell;
    public static class_2248 Starfish;
    public static class_2248 Geyser;
    public static class_2248 NetherGeyser;
    public static List<class_1799> groupItems;
    public static class_1761 RocksGroup;
    public static final class_5321<class_1761> ROCKS_GROUP;

    public void onInitialize() {
        class_2960 id;
        RocksConfig.init((String)MOD_ID, RocksConfig.class);
        if (polymerMode) {
            polymerMode = RocksConfig.enablePolymerMode && (RocksConfig.forcePolymerMode || !PlatformFunctions.isClientEnv());
        }
        PayloadTypeRegistry.playC2S().register(HelloPayload.PACKET_ID, HelloPayload.codec);
        ServerPlayNetworking.registerGlobalReceiver(HelloPayload.PACKET_ID, (payload, context) -> {
            if (!RocksConfig.forcePolymerMode) {
                playersWithMod.add(context.player());
                if (polymerMode) {
                    PolyUtil.hideElementHolders(context.player());
                }
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((playNetworkHandler, server) -> playersWithMod.remove(playNetworkHandler.field_14140));
        if (polymerMode) {
            PolyUtil.init();
        }
        for (RockType rockType : RockType.values()) {
            id = RocksMain.id(rockType.getName());
            rocksByType.put(rockType, RegistryUtil.registerBlockWithItem(id, polymerMode ? PolyUtil.newRockPolymer(id) : new Rock(id)));
            if (rockType == RockType.GRAVEL) continue;
            splittersByType.put(rockType, RegistryUtil.registerItem(RocksMain.id(rockType.getFragment().getName()), RocksMain.simpleItem(RocksMain.id(rockType.getFragment().getName()))));
        }
        for (Enum enum_ : StickType.values()) {
            id = RocksMain.id(((StickType)enum_).getName() + "_stick");
            sticksByType.put((StickType)enum_, RegistryUtil.registerBlockWithItem(id, polymerMode ? PolyUtil.newStickPolymer(id) : new Stick(id)));
        }
        Pinecone = RegistryUtil.registerBlockWithItem(PINECONE, polymerMode ? PolyUtil.newPineconePolymer(PINECONE) : new Pinecone(PINECONE));
        Seashell = RegistryUtil.registerBlockWithItem(SEASHELL, polymerMode ? PolyUtil.newSeashellPolymer(SEASHELL) : new Seashell(SEASHELL));
        Starfish = RegistryUtil.registerBlockWithItem(STARFISH, polymerMode ? PolyUtil.newStarfishPolymer(STARFISH) : new Starfish(STARFISH));
        Geyser = RegistryUtil.registerBlockWithItem(GEYSER, polymerMode ? PolyUtil.newOverworldGeyserPolymer(GEYSER) : new OverworldGeyser(GEYSER));
        NetherGeyser = RegistryUtil.registerBlockWithItem(NETHER_GEYSER, polymerMode ? PolyUtil.newNetherGeyserPolymer(NETHER_GEYSER) : new NetherGeyser(NETHER_GEYSER));
        RocksMain.registerItemGroup();
        FeatureRegistry.init();
        FeatureInjector.init();
        BlockEntityInit.init();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static boolean hasRequiredPolymerModules() {
        return PlatformFunctions.isModLoaded((String)"polymer-core") && PlatformFunctions.isModLoaded((String)"polymer-blocks") && PlatformFunctions.isModLoaded((String)"polymer-resource-pack") && PlatformFunctions.isModLoaded((String)"polymer-virtual-entity") && PlatformFunctions.isModLoaded((String)"factorytools");
    }

    public static class_1792 simpleItem(class_2960 id) {
        if (polymerMode) {
            return PolyUtil.simplePolymerItem(id);
        }
        return new class_1792(new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id)));
    }

    public static void registerItemGroup() {
        if (polymerMode) {
            PolyUtil.registerPolymerGroup();
        } else {
            RocksGroup = FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.rocks.rocks")).method_47320(() -> new class_1799((class_1935)rocksByType.get((Object)RockType.STONE))).method_47317((displayContext, entries) -> entries.method_45423(groupItems)).method_47324();
            class_2378.method_39197((class_2378)class_7923.field_44687, ROCKS_GROUP, (Object)RocksGroup);
        }
    }

    static {
        groupItems = new ArrayList<class_1799>();
        ROCKS_GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)class_2960.method_60655((String)MOD_ID, (String)MOD_ID));
    }
}

