/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import eu.midnightdust.motschen.rocks.RocksMain;
import eu.midnightdust.motschen.rocks.datagen.LanguageHelper;
import eu.midnightdust.motschen.rocks.util.RockType;
import eu.midnightdust.motschen.rocks.util.StickType;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public abstract class Language
extends FabricLanguageProvider {
    LanguageHelper langHelper;

    protected Language(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    protected Language(FabricDataOutput dataOutput, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, languageCode, registryLookup);
    }

    public String getCommonString(String first, String second) {
        StringBuilder commonTranslation = new StringBuilder();
        block0: for (String subFirst : first.split(" ")) {
            for (String subSecond : second.split(" ")) {
                Object commonPart = "";
                if (!second.contains(" ")) {
                    char c;
                    String temp;
                    char[] cArray = subFirst.toCharArray();
                    int n = cArray.length;
                    for (int i = 0; i < n && subSecond.startsWith(temp = (String)commonPart + (c = cArray[i])); ++i) {
                        commonPart = temp;
                    }
                } else if (subFirst.equals(subSecond)) {
                    commonPart = subSecond;
                }
                if (((String)commonPart).isEmpty()) continue;
                commonTranslation.append((String)commonPart).append(" ");
                continue block0;
            }
        }
        return commonTranslation.substring(0, commonTranslation.length() - 1);
    }

    protected static void addBlock(FabricLanguageProvider.TranslationBuilder translationBuilder, class_2248 block, String value) {
        translationBuilder.add(block, value);
        translationBuilder.add(block.method_8389(), value);
    }

    protected static void midnightconfig(FabricLanguageProvider.TranslationBuilder translationBuilder, String key, String value) {
        translationBuilder.add("rocks.midnightconfig." + key, value);
    }

    public void createRepeatedTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, String rockWord, String splitterWord, String stickWord) {
        class_2248 block;
        for (RockType rockType : RockType.values()) {
            block = (class_2248)class_7923.field_41175.method_63535(RocksMain.id(rockType.getName()));
            String baseTranslation = this.langHelper.translate(rockType.getStoneBlock().method_63499());
            Language.addBlock(translationBuilder, block, baseTranslation + rockWord);
            if (rockType == RockType.GRAVEL) continue;
            String splitterBaseTranslation = this.langHelper.translate(rockType.getFragment().getStoneBlock().method_63499());
            class_1792 splitter = (class_1792)class_7923.field_41178.method_63535(RocksMain.id(rockType.getFragment().getName()));
            translationBuilder.add(splitter, splitterBaseTranslation + splitterWord);
        }
        for (Enum enum_ : StickType.values()) {
            block = (class_2248)class_7923.field_41175.method_63535(RocksMain.id(((StickType)enum_).getName() + "_stick"));
            Object object = ((StickType)enum_).getBaseBlock();
            if (!(object instanceof class_2248)) continue;
            class_2248 logBlock = object;
            object = class_7923.field_41175.method_63535(class_2960.method_60656((String)(((StickType)enum_).getName() + "_planks")));
            if (!(object instanceof class_2248)) continue;
            Object plankBlock = object;
            object = class_7923.field_41175.method_63535(class_2960.method_60656((String)(((StickType)enum_).getName() + "_stairs")));
            if (!(object instanceof class_2248)) continue;
            Object stairBlock = object;
            String logTranslation = this.langHelper.translate(logBlock.method_63499());
            String plankTranslation = this.langHelper.translate(plankBlock.method_63499());
            String stairTranslation = this.langHelper.translate(stairBlock.method_63499());
            Language.addBlock(translationBuilder, block, this.getCommonString(this.getCommonString(logTranslation, plankTranslation), this.getCommonString(plankTranslation, stairTranslation)) + stickWord);
        }
    }

    public static class German
    extends Language {
        public German(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "de_de", registryLookup);
            this.langHelper = new LanguageHelper("de_de");
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            translationBuilder.add("itemGroup.rocks.rocks", "This Rocks!");
            this.createRepeatedTranslations(translationBuilder, "brocken", "splitter", "stock");
            German.addBlock(translationBuilder, RocksMain.Geyser, "Geysir");
            German.addBlock(translationBuilder, RocksMain.NetherGeyser, "Nether-Geysir");
            German.addBlock(translationBuilder, RocksMain.Starfish, "Seestern");
            German.addBlock(translationBuilder, RocksMain.Seashell, "Muschel");
            German.addBlock(translationBuilder, RocksMain.Pinecone, "Tannenzapfen");
            German.midnightconfig(translationBuilder, "title", "This Rocks! Config");
            German.midnightconfig(translationBuilder, "category.rocks", "Brocken");
            German.midnightconfig(translationBuilder, "category.sticks", "St\u00f6cke");
            German.midnightconfig(translationBuilder, "category.misc", "Sonstiges");
            German.midnightconfig(translationBuilder, "category.effects", "Effekte");
            for (String key : Set.of("needs_restart", "needs_restart1", "needs_restart2")) {
                German.midnightconfig(translationBuilder, key, "\u00a7cStarte das Spiel neu, nachdem du \u00c4nderungen vorgenommen hast!");
            }
            German.midnightconfig(translationBuilder, "rockMix", "Gemischte Brocken");
            German.midnightconfig(translationBuilder, "rockMix.tooltip", "F\u00fcgt kleine Mengen an Granit-, Andesit- und Diorit-Brocken zu allen Biomen hinzu");
            German.midnightconfig(translationBuilder, "underwaterSeashell", "Unterwasser-Muschel");
            German.midnightconfig(translationBuilder, "underwaterStarfish", "Unterwasser-Seestern");
            German.midnightconfig(translationBuilder, "geyserLevitation", "Geysir Schwebeeffekt");
            German.midnightconfig(translationBuilder, "netherGeyserDamage", "Nether Geysir Schaden");
            German.midnightconfig(translationBuilder, "biomeExclusions", "Ausgeschlosene Biome");
            German.midnightconfig(translationBuilder, "biomeExclusions.tooltip", "In diesen Biomen werden keine Features der Mod generiert.\nFormat: modid:biome_name");
            German.midnightconfig(translationBuilder, "enablePolymerMode", "Aktiviere Polymer-Modus");
            German.midnightconfig(translationBuilder, "enablePolymerMode.tooltip", "Erlaubt der Mod, komplett serverseitig zu funktionieren, wenn Polymer und FactoryTools installiert sind");
            German.midnightconfig(translationBuilder, "forcePolymerMode", "Erzwinge Polymer-Modus");
            German.midnightconfig(translationBuilder, "forcePolymerMode.tooltip", "Aktiviert den Polymer-Modus auch f\u00fcr Clients, die die ThisRocks! installiert haben");
            German.midnightconfig(translationBuilder, "polymerViewDistance", "Polymer-Sichtweite");
        }
    }

    public static class English
    extends Language {
        public English(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
            this.langHelper = new LanguageHelper("en_us");
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            translationBuilder.add("itemGroup.rocks.rocks", "This Rocks!");
            this.createRepeatedTranslations(translationBuilder, " Rock", " Fragment", " Stick");
            English.addBlock(translationBuilder, RocksMain.Geyser, "Geyser");
            English.addBlock(translationBuilder, RocksMain.NetherGeyser, "Nether Geyser");
            English.addBlock(translationBuilder, RocksMain.Starfish, "Starfish");
            English.addBlock(translationBuilder, RocksMain.Seashell, "Seashell");
            English.addBlock(translationBuilder, RocksMain.Pinecone, "Pinecone");
            English.midnightconfig(translationBuilder, "title", "This Rocks! Config");
            English.midnightconfig(translationBuilder, "category.rocks", "Rocks");
            English.midnightconfig(translationBuilder, "category.sticks", "Sticks");
            English.midnightconfig(translationBuilder, "category.misc", "Miscellaneous");
            English.midnightconfig(translationBuilder, "category.effects", "Effects");
            for (String key : Set.of("needs_restart", "needs_restart1", "needs_restart2")) {
                English.midnightconfig(translationBuilder, key, "\u00a7cRestart the game after changing options here!");
            }
            English.midnightconfig(translationBuilder, "rockMix", "Mixed Rocks");
            English.midnightconfig(translationBuilder, "rockMix.tooltip", "Adds small batches of Granite, Andesite and Diorite rocks to all biomes");
            English.midnightconfig(translationBuilder, "underwaterSeashell", "Underwater Seashell");
            English.midnightconfig(translationBuilder, "underwaterStarfish", "Underwater Starfish");
            English.midnightconfig(translationBuilder, "geyserLevitation", "Geyser Levitation");
            English.midnightconfig(translationBuilder, "netherGeyserDamage", "Nether Geyser Damage");
            English.midnightconfig(translationBuilder, "biomeExclusions", "Excluded biomes");
            English.midnightconfig(translationBuilder, "biomeExclusions.tooltip", "No feature will generate in these biomes.\nFormat: modid:biome_name");
            English.midnightconfig(translationBuilder, "enablePolymerMode", "Enable Polymer Mode");
            English.midnightconfig(translationBuilder, "enablePolymerMode.tooltip", "Allows the mod to work fully server-sided when used in combination with Polymer and FactoryTools");
            English.midnightconfig(translationBuilder, "forcePolymerMode", "Force Polymer Mode");
            English.midnightconfig(translationBuilder, "forcePolymerMode.tooltip", "Also enables Polymer mode for clients that have ThisRocks! installed");
            English.midnightconfig(translationBuilder, "polymerViewDistance", "Polymer View Distance");
        }
    }
}

