/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.util;

import eu.midnightdust.motschen.rocks.RocksMain;
import java.util.Arrays;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public enum RockType {
    STONE("rock"),
    ANDESITE("andesite_rock"),
    GRANITE("granite_rock"),
    DIORITE("diorite_rock"),
    GRAVEL("gravel_rock"),
    SANDSTONE("sand_rock"),
    RED_SANDSTONE("red_sand_rock"),
    NETHERRACK("netherrack_rock"),
    SOUL_SOIL("soul_soil_rock"),
    END_STONE("end_stone_rock"),
    ICE("ice_rock");

    private final String name;

    private RockType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getStoneId() {
        return class_2960.method_60656((String)this.toString().toLowerCase());
    }

    public class_2248 getStoneBlock() {
        return (class_2248)class_7923.field_41175.method_63535(this.getStoneId());
    }

    public class_2960[] getVariations() {
        class_2960[] variations = new class_2960[]{RocksMain.id(this.name + "_tiny"), RocksMain.id(this.name + "_small"), RocksMain.id(this.name + "_medium"), RocksMain.id(this.name + "_large")};
        return variations;
    }

    public static RockType fromBlockName(String name) {
        return Arrays.stream(RockType.values()).filter(type -> name.replace("block.rocks.", "").replace("tiny", "").replace("small_", "").replace("medium_", "").replace("large_", "").equals(type.getName())).findFirst().orElse(STONE);
    }

    public Fragment getFragment() {
        return new Fragment(this);
    }

    public static class Fragment {
        private final RockType type;

        Fragment(RockType type) {
            this.type = type;
        }

        public String getName() {
            Object splitterName = this.type.name().toLowerCase() + "_splitter";
            if (this.type.equals((Object)STONE)) {
                splitterName = "cobblestone_splitter";
            }
            return splitterName;
        }

        public class_2960 getStoneId() {
            if (this.type == STONE) {
                return class_2960.method_60656((String)"cobblestone");
            }
            return class_2960.method_60656((String)this.type.toString().toLowerCase());
        }

        public class_2248 getStoneBlock() {
            return (class_2248)class_7923.field_41175.method_63535(this.getStoneId());
        }
    }
}

