/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block;

import com.blocklogic.realfilingreborn.block.custom.FilingCabinetBlock;
import com.blocklogic.realfilingreborn.block.custom.TestBlocksGeneratorBlock;
import com.blocklogic.realfilingreborn.block.custom.TestNBTItemsGeneratorBlock;
import com.blocklogic.realfilingreborn.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"realfilingreborn");
    public static final DeferredBlock<Block> FILING_CABINET = ModBlocks.registerBlock("filing_cabinet", () -> new FilingCabinetBlock(BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> TEST_BLOCKS_GENERATOR = ModBlocks.registerDevBlock("test_blocks_generator", () -> new TestBlocksGeneratorBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).sound(SoundType.STONE).noLootTable()));
    public static final DeferredBlock<Block> TEST_NBT_ITEMS_GENERATOR = ModBlocks.registerDevBlock("test_nbt_items_generator", () -> new TestNBTItemsGeneratorBlock(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).sound(SoundType.STONE).noLootTable()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerDevBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerDevBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> void registerDevBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

