/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.custom;

import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import com.blocklogic.realfilingreborn.screen.custom.FilingCabinetMenu;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FilingCabinetBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<FilingCabinetBlock> CODEC = FilingCabinetBlock.simpleCodec(FilingCabinetBlock::new);

    public FilingCabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FilingCabinetBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FilingCabinetBlockEntity) {
            FilingCabinetBlockEntity filingCabinetBlockEntity = (FilingCabinetBlockEntity)blockEntity;
            filingCabinetBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private void openFilingCabinetMenu(FilingCabinetBlockEntity blockEntity, ServerPlayer player, BlockPos pos) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, playerEntity) -> new FilingCabinetMenu(id, inventory, blockEntity), (Component)Component.translatable((String)"menu.realfilingreborn.menu_title")), pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        FilingCabinetBlockEntity filingCabinetBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FilingCabinetBlockEntity) {
            filingCabinetBlockEntity = (FilingCabinetBlockEntity)blockEntity;
            if (player.isCrouching()) {
                if (!level.isClientSide()) {
                    this.openFilingCabinetMenu(filingCabinetBlockEntity, (ServerPlayer)player, pos);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof FilingCabinetBlockEntity) {
            filingCabinetBlockEntity = (FilingCabinetBlockEntity)blockEntity;
            ItemStack heldItem = player.getItemInHand(hand);
            if (heldItem.getItem() instanceof FilingFolderItem || heldItem.getItem() instanceof NBTFilingFolderItem) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                for (int i = 0; i < 5; ++i) {
                    if (!filingCabinetBlockEntity.inventory.getStackInSlot(i).isEmpty()) continue;
                    ItemStack folderStack = heldItem.copyWithCount(1);
                    filingCabinetBlockEntity.inventory.setStackInSlot(i, folderStack);
                    heldItem.shrink(1);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    filingCabinetBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folders_full"), true);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }
}

