/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.entity.renderer;

import com.blocklogic.realfilingreborn.block.custom.FilingCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FilingCabinetBlockEntityRenderer
implements BlockEntityRenderer<FilingCabinetBlockEntity> {
    public FilingCabinetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FilingCabinetBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)FilingCabinetBlock.FACING);
        int blockLight = level.getBrightness(LightLayer.BLOCK, blockEntity.getBlockPos());
        int skyLight = level.getBrightness(LightLayer.SKY, blockEntity.getBlockPos());
        int itemLight = 0xF000F0;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        for (int slot = 0; slot < blockEntity.inventory.getSlots(); ++slot) {
            NBTFilingFolderItem.NBTFolderContents contents;
            ItemStack folderStack = blockEntity.inventory.getStackInSlot(slot);
            if (folderStack.isEmpty()) continue;
            ItemStack storedItem = null;
            if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                FilingFolderItem.FolderContents contents2 = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents2 != null && contents2.storedItemId().isPresent() && contents2.count() > 0) {
                    storedItem = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(contents2.storedItemId().get()));
                }
            } else if (folderStack.getItem() instanceof NBTFilingFolderItem && (contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) != null && contents.storedItemId().isPresent() && !contents.storedItems().isEmpty()) {
                storedItem = contents.storedItems().get(0).stack().copy();
            }
            if (storedItem == null) continue;
            float offsetX = (float)(slot - 2) * 0.15f;
            this.renderItem(storedItem, offsetX, poseStack, bufferSource, itemLight, facing);
        }
        poseStack.popPose();
    }

    private void renderItem(ItemStack stack, float offsetX, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Direction facing) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        poseStack.pushPose();
        float scale = 0.12f;
        poseStack.scale(scale, scale, scale);
        switch (facing) {
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                poseStack.translate(offsetX / scale, 0.1f / scale, -0.503f / scale);
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.translate(offsetX / scale, 0.1f / scale, -0.503f / scale);
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.translate(offsetX / scale, 0.1f / scale, 0.503f / scale);
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                poseStack.translate(offsetX / scale, 0.1f / scale, 0.503f / scale);
            }
        }
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, null, 0);
        poseStack.popPose();
    }
}

