/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.item.custom;

import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EraserItem
extends Item {
    public EraserItem(Item.Properties properties) {
        super(properties.durability(64));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Record contents;
        ItemStack eraserStack = player.getItemInHand(hand);
        ItemStack folderStack = player.getItemInHand(InteractionHand.OFF_HAND);
        if (folderStack.isEmpty() || !(folderStack.getItem() instanceof FilingFolderItem) && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
            return InteractionResultHolder.pass((Object)eraserStack);
        }
        boolean hasFolderContents = false;
        boolean isUnassigned = false;
        if (folderStack.getItem() instanceof NBTFilingFolderItem) {
            contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
            if (contents != null && ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems() != null && !((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().isEmpty()) {
                hasFolderContents = true;
            }
            if (contents == null || ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isEmpty()) {
                isUnassigned = true;
            }
        } else {
            contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
            if (contents != null && ((FilingFolderItem.FolderContents)contents).count() > 0) {
                hasFolderContents = true;
            }
            if (contents == null || ((FilingFolderItem.FolderContents)contents).storedItemId().isEmpty()) {
                isUnassigned = true;
            }
        }
        if (hasFolderContents) {
            if (!level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_not_empty").withStyle(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.consume((Object)eraserStack);
        }
        if (isUnassigned) {
            if (!level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_not_assigned").withStyle(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.consume((Object)eraserStack);
        }
        if (folderStack.getItem() instanceof NBTFilingFolderItem) {
            contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
            if (contents != null && ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isPresent()) {
                int maxDamage;
                int currentDamage;
                folderStack.remove((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
                folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)new NBTFilingFolderItem.NBTFolderContents(Optional.empty(), new ArrayList<NBTFilingFolderItem.SerializedItemStack>()));
                if (!player.getAbilities().instabuild && (currentDamage = eraserStack.getDamageValue()) < (maxDamage = eraserStack.getMaxDamage())) {
                    eraserStack.setDamageValue(currentDamage + 1);
                }
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_erased").withStyle(ChatFormatting.GREEN), true);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResultHolder.success((Object)eraserStack);
            }
        } else {
            contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
            if (contents != null && ((FilingFolderItem.FolderContents)contents).storedItemId().isPresent()) {
                int maxDamage;
                int currentDamage;
                ItemStack freshFolder = new ItemStack((ItemLike)folderStack.getItem());
                freshFolder.setCount(folderStack.getCount());
                player.setItemInHand(InteractionHand.OFF_HAND, freshFolder);
                if (!player.getAbilities().instabuild && (currentDamage = eraserStack.getDamageValue()) < (maxDamage = eraserStack.getMaxDamage())) {
                    eraserStack.setDamageValue(currentDamage + 1);
                }
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_erased").withStyle(ChatFormatting.GREEN), true);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResultHolder.success((Object)eraserStack);
            }
        }
        return InteractionResultHolder.pass((Object)eraserStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.eraser_info").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

