/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.item.custom;

import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FilingFolderItem
extends Item {
    private static final Codec<FolderContents> FOLDER_CONTENTS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("storedItemId").forGetter(FolderContents::storedItemId), (App)Codec.INT.fieldOf("count").forGetter(FolderContents::count)).apply((Applicative)instance, FolderContents::new));
    public static final StreamCodec<ByteBuf, ResourceLocation> RESOURCE_LOCATION_STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ResourceLocation::parse, ResourceLocation::toString);
    private static final StreamCodec<ByteBuf, FolderContents> FOLDER_CONTENTS_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional(RESOURCE_LOCATION_STREAM_CODEC), FolderContents::storedItemId, (StreamCodec)ByteBufCodecs.INT, FolderContents::count, FolderContents::new);
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"realfilingreborn");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<FolderContents>> FOLDER_CONTENTS = DATA_COMPONENTS.register("folder_contents", () -> DataComponentType.builder().persistent(FOLDER_CONTENTS_CODEC).networkSynchronized(FOLDER_CONTENTS_STREAM_CODEC).build());

    public FilingFolderItem(Item.Properties properties) {
        super(properties);
        properties.component((DataComponentType)FOLDER_CONTENTS.value(), (Object)new FolderContents(Optional.empty(), 0));
    }

    public static boolean hasSignificantNBT(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.isDamaged()) {
            return true;
        }
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (enchantments != null && !enchantments.isEmpty()) {
            return true;
        }
        ItemEnchantments stored = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
        if (stored != null && !stored.isEmpty()) {
            return true;
        }
        if (stack.get(DataComponents.CUSTOM_NAME) != null) {
            return true;
        }
        ItemLore lore = (ItemLore)stack.get(DataComponents.LORE);
        if (lore != null && !lore.lines().isEmpty()) {
            return true;
        }
        PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        return potion != null && (!potion.customEffects().isEmpty() || !potion.potion().isEmpty());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack folderStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)folderStack);
        }
        ItemStack itemToStore = player.getItemInHand(InteractionHand.OFF_HAND);
        if (itemToStore.isEmpty() || itemToStore.getItem() instanceof FilingFolderItem || itemToStore.getItem() instanceof NBTFilingFolderItem) {
            if (itemToStore.getItem() instanceof FilingFolderItem || itemToStore.getItem() instanceof NBTFilingFolderItem) {
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.no_folder_ception"), true);
                return InteractionResultHolder.pass((Object)folderStack);
            }
            FolderContents contents = (FolderContents)folderStack.get((DataComponentType)FOLDER_CONTENTS.value());
            if (contents == null) {
                contents = new FolderContents(Optional.empty(), 0);
                folderStack.set((DataComponentType)FOLDER_CONTENTS.value(), (Object)contents);
            }
            if (player.isShiftKeyDown() && contents.storedItemId().isPresent()) {
                if (folderStack.getCount() > 1) {
                    ItemStack singleFolder = folderStack.copy();
                    singleFolder.setCount(1);
                    InteractionResultHolder<ItemStack> result = this.extractItems(level, player, singleFolder, contents);
                    ItemStack modifiedFolder = (ItemStack)result.getObject();
                    if (result.getResult().consumesAction()) {
                        folderStack.shrink(1);
                        if (!player.getInventory().add(modifiedFolder)) {
                            player.drop(modifiedFolder, false);
                        }
                        return InteractionResultHolder.success((Object)folderStack);
                    }
                    return result;
                }
                return this.extractItems(level, player, folderStack, contents);
            }
            return InteractionResultHolder.pass((Object)folderStack);
        }
        if (FilingFolderItem.hasSignificantNBT(itemToStore)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.standard_folder_no_nbt"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        if (!player.isShiftKeyDown() && folderStack.getCount() > 1) {
            ItemStack singleFolder = folderStack.copy();
            singleFolder.setCount(1);
            FolderContents contents = (FolderContents)singleFolder.get((DataComponentType)FOLDER_CONTENTS.value());
            if (contents == null) {
                contents = new FolderContents(Optional.empty(), 0);
                singleFolder.set((DataComponentType)FOLDER_CONTENTS.value(), (Object)contents);
            }
            InteractionResultHolder<ItemStack> result = this.storeItems(level, player, singleFolder, itemToStore, contents);
            ItemStack modifiedFolder = (ItemStack)result.getObject();
            folderStack.shrink(1);
            if (!player.getInventory().add(modifiedFolder)) {
                player.drop(modifiedFolder, false);
            }
            return InteractionResultHolder.success((Object)folderStack);
        }
        FolderContents contents = (FolderContents)folderStack.get((DataComponentType)FOLDER_CONTENTS.value());
        if (contents == null) {
            contents = new FolderContents(Optional.empty(), 0);
            folderStack.set((DataComponentType)FOLDER_CONTENTS.value(), (Object)contents);
        }
        return this.storeItems(level, player, folderStack, itemToStore, contents);
    }

    private InteractionResultHolder<ItemStack> extractItems(Level level, Player player, ItemStack folderStack, FolderContents contents) {
        if (contents == null || contents.storedItemId().isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_empty"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        if (contents.count() <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_empty"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        ResourceLocation itemId = contents.storedItemId().get();
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        ItemStack dummyStack = new ItemStack((ItemLike)item);
        int extractAmount = Math.min(Math.min(contents.count(), item.getMaxStackSize(dummyStack)), 64);
        ItemStack extractedStack = new ItemStack((ItemLike)item, extractAmount);
        int newCount = contents.count() - extractAmount;
        FolderContents newContents = new FolderContents(contents.storedItemId(), Math.max(0, newCount));
        folderStack.set((DataComponentType)FOLDER_CONTENTS.value(), (Object)newContents);
        if (player.getInventory().add(extractedStack)) {
            return InteractionResultHolder.success((Object)folderStack);
        }
        player.drop(extractedStack, false);
        return InteractionResultHolder.success((Object)folderStack);
    }

    private InteractionResultHolder<ItemStack> storeItems(Level level, Player player, ItemStack folderStack, ItemStack itemToStore, FolderContents contents) {
        ResourceLocation effectiveItemId;
        if (itemToStore.isEmpty() || itemToStore.getItem() instanceof FilingFolderItem) {
            return InteractionResultHolder.pass((Object)folderStack);
        }
        if (FilingFolderItem.hasSignificantNBT(itemToStore)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.standard_folder_no_nbt"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        if (contents == null) {
            contents = new FolderContents(Optional.empty(), 0);
            folderStack.set((DataComponentType)FOLDER_CONTENTS.value(), (Object)contents);
        }
        ResourceLocation newItemId = BuiltInRegistries.ITEM.getKey((Object)itemToStore.getItem());
        if (contents == null) {
            return InteractionResultHolder.fail((Object)folderStack);
        }
        Optional<ResourceLocation> currentItemIdOpt = contents.storedItemId();
        if (currentItemIdOpt.isEmpty()) {
            effectiveItemId = newItemId;
        } else {
            effectiveItemId = currentItemIdOpt.get();
            if (!effectiveItemId.equals((Object)newItemId)) {
                Item storedItem = (Item)BuiltInRegistries.ITEM.get(effectiveItemId);
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.wrong_item_type", (Object[])new Object[]{storedItem.getDescription().copy().withStyle(ChatFormatting.YELLOW)}), true);
                return InteractionResultHolder.fail((Object)folderStack);
            }
        }
        int maxToAdd = Integer.MAX_VALUE - contents.count();
        int toAdd = Math.min(itemToStore.getCount(), maxToAdd);
        if (toAdd <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folder_full"), true);
            return InteractionResultHolder.fail((Object)folderStack);
        }
        FolderContents newContents = new FolderContents(Optional.of(effectiveItemId), contents.count() + toAdd);
        folderStack.set((DataComponentType)FOLDER_CONTENTS.value(), (Object)newContents);
        itemToStore.shrink(toAdd);
        return InteractionResultHolder.success((Object)folderStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        FolderContents contents = (FolderContents)stack.get((DataComponentType)FOLDER_CONTENTS.value());
        if (contents != null && contents.storedItemId().isPresent()) {
            ResourceLocation itemId = contents.storedItemId().get();
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.stored_item", (Object[])new Object[]{Component.literal((String)item.getDescription().getString()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
            if (contents.count() > 0) {
                tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.item_count", (Object[])new Object[]{Component.literal((String)String.format("%,d", contents.count())).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.empty_folder").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.unregistered_folder").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.realfilingreborn.standard_folder_info").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public record FolderContents(Optional<ResourceLocation> storedItemId, int count) {
    }
}

