/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.custom;

import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import com.blocklogic.realfilingreborn.screen.custom.FilingCabinetMenu;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FilingCabinetBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<FilingCabinetBlock> CODEC = FilingCabinetBlock.simpleCodec(FilingCabinetBlock::new);

    public FilingCabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FilingCabinetBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FilingCabinetBlockEntity) {
            FilingCabinetBlockEntity filingCabinetBlockEntity = (FilingCabinetBlockEntity)blockEntity;
            filingCabinetBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private void openFilingCabinetMenu(FilingCabinetBlockEntity blockEntity, ServerPlayer player, BlockPos pos) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, playerEntity) -> new FilingCabinetMenu(id, inventory, blockEntity), (Component)Component.translatable((String)"menu.realfilingreborn.menu_title")), pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        FilingCabinetBlockEntity filingCabinetBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FilingCabinetBlockEntity) {
            filingCabinetBlockEntity = (FilingCabinetBlockEntity)blockEntity;
            if (player.isCrouching()) {
                if (!level.isClientSide()) {
                    this.openFilingCabinetMenu(filingCabinetBlockEntity, (ServerPlayer)player, pos);
                    level.playSound(player, pos, SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof FilingCabinetBlockEntity) {
            filingCabinetBlockEntity = (FilingCabinetBlockEntity)blockEntity;
            ItemStack heldItem = player.getItemInHand(hand);
            if (heldItem.getItem() instanceof FilingFolderItem || heldItem.getItem() instanceof NBTFilingFolderItem) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                for (int i = 0; i < 5; ++i) {
                    if (!filingCabinetBlockEntity.inventory.getStackInSlot(i).isEmpty()) continue;
                    ItemStack folderStack = heldItem.copyWithCount(1);
                    filingCabinetBlockEntity.inventory.setStackInSlot(i, folderStack);
                    heldItem.shrink(1);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    filingCabinetBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.folders_full"), true);
                return ItemInteractionResult.SUCCESS;
            }
            if (!(heldItem.isEmpty() || heldItem.getItem() instanceof FilingFolderItem || heldItem.getItem() instanceof NBTFilingFolderItem)) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                boolean hasNbt = NBTFilingFolderItem.hasSignificantNBT(heldItem);
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)heldItem.getItem());
                for (int i = 0; i < 5; ++i) {
                    int toAdd;
                    Record contents;
                    ItemStack folderStack = filingCabinetBlockEntity.inventory.getStackInSlot(i);
                    if (folderStack.isEmpty()) continue;
                    if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                        if (hasNbt || (contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value())) == null) continue;
                        if (((FilingFolderItem.FolderContents)contents).storedItemId().isEmpty()) {
                            FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(Optional.of(itemId), heldItem.getCount());
                            folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                            heldItem.shrink(heldItem.getCount());
                            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.5f);
                            level.sendBlockUpdated(pos, state, state, 2);
                            filingCabinetBlockEntity.setChanged();
                            return ItemInteractionResult.SUCCESS;
                        }
                        if (!((FilingFolderItem.FolderContents)contents).storedItemId().get().equals((Object)itemId)) continue;
                        int maxToAdd = Integer.MAX_VALUE - ((FilingFolderItem.FolderContents)contents).count();
                        toAdd = Math.min(heldItem.getCount(), maxToAdd);
                        if (toAdd <= 0) continue;
                        FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(((FilingFolderItem.FolderContents)contents).storedItemId(), ((FilingFolderItem.FolderContents)contents).count() + toAdd);
                        folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                        heldItem.shrink(toAdd);
                        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.5f);
                        level.sendBlockUpdated(pos, state, state, 2);
                        filingCabinetBlockEntity.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (!(folderStack.getItem() instanceof NBTFilingFolderItem) || !hasNbt || (contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) == null) continue;
                    if (((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isEmpty()) {
                        ArrayList<NBTFilingFolderItem.SerializedItemStack> newItems = new ArrayList<NBTFilingFolderItem.SerializedItemStack>();
                        toAdd = Math.min(heldItem.getCount(), 128);
                        for (int count = 0; count < toAdd; ++count) {
                            ItemStack singleItem = heldItem.copy();
                            singleItem.setCount(1);
                            newItems.add(new NBTFilingFolderItem.SerializedItemStack(singleItem));
                        }
                        NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(Optional.of(itemId), newItems);
                        folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                        heldItem.shrink(toAdd);
                        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.5f);
                        level.sendBlockUpdated(pos, state, state, 2);
                        filingCabinetBlockEntity.setChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (!((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().get().equals((Object)itemId) || ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().size() >= 128) continue;
                    ArrayList<NBTFilingFolderItem.SerializedItemStack> newItems = new ArrayList<NBTFilingFolderItem.SerializedItemStack>(((NBTFilingFolderItem.NBTFolderContents)contents).storedItems());
                    int availableSpace = 128 - newItems.size();
                    int toAdd2 = Math.min(heldItem.getCount(), availableSpace);
                    for (int count = 0; count < toAdd2; ++count) {
                        ItemStack singleItem = heldItem.copy();
                        singleItem.setCount(1);
                        newItems.add(new NBTFilingFolderItem.SerializedItemStack(singleItem));
                    }
                    NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId(), newItems);
                    folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                    heldItem.shrink(toAdd2);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.5f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    filingCabinetBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.realfilingreborn.no_compatible_folder"), true);
                return ItemInteractionResult.SUCCESS;
            }
            if (!level.isClientSide()) {
                this.openFilingCabinetMenu(filingCabinetBlockEntity, (ServerPlayer)player, pos);
                level.playSound(player, pos, SoundEvents.VILLAGER_WORK_CARTOGRAPHER, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

