/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.entity.renderer;

import com.blocklogic.realfilingreborn.block.custom.FilingCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.FilingCabinetBlockEntity;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FilingCabinetBlockEntityRenderer
implements BlockEntityRenderer<FilingCabinetBlockEntity> {
    public FilingCabinetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FilingCabinetBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)FilingCabinetBlock.FACING);
        int itemLight = 0xF000F0;
        poseStack.pushPose();
        this.setupFaceTransform(poseStack, facing);
        for (int slot = 0; slot < blockEntity.inventory.getSlots(); ++slot) {
            NBTFilingFolderItem.NBTFolderContents contents;
            ItemStack folderStack = blockEntity.inventory.getStackInSlot(slot);
            if (folderStack.isEmpty()) continue;
            ItemStack storedItem = null;
            String countText = "";
            if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                FilingFolderItem.FolderContents contents2 = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents2 != null && contents2.storedItemId().isPresent() && contents2.count() > 0) {
                    storedItem = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(contents2.storedItemId().get()));
                    int count = contents2.count();
                    countText = count >= 1000000 ? String.format("%.1fM", (double)count / 1000000.0) : (count >= 1000 ? String.format("%.1fK", (double)count / 1000.0) : String.valueOf(count));
                }
            } else if (folderStack.getItem() instanceof NBTFilingFolderItem && (contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) != null && contents.storedItemId().isPresent() && !contents.storedItems().isEmpty()) {
                storedItem = contents.storedItems().get(0).stack().copy();
                countText = String.valueOf(contents.storedItems().size());
            }
            if (storedItem == null) continue;
            float offsetX = (float)(slot - 2) * 0.15f;
            this.renderSlotContent(storedItem, countText, offsetX, poseStack, bufferSource, itemLight);
        }
        poseStack.popPose();
    }

    private void setupFaceTransform(PoseStack poseStack, Direction facing) {
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        if (facing == Direction.NORTH) {
            poseStack.translate(0.0, 0.025, 0.535);
        } else if (facing == Direction.EAST) {
            poseStack.translate(-0.535, 0.025, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.translate(0.0, 0.025, -0.535);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        } else if (facing == Direction.WEST) {
            poseStack.translate(0.535, 0.025, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        poseStack.translate(0.0, 0.0, -0.03125);
    }

    private void renderSlotContent(ItemStack stack, String countText, float offsetX, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(offsetX, -0.2f, 0.0f);
        poseStack.pushPose();
        poseStack.scale(0.15f, 0.15f, 0.15f);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, null, 0);
        poseStack.popPose();
        if (!countText.isEmpty()) {
            this.renderText(countText, poseStack, bufferSource, packedLight);
        }
        poseStack.popPose();
    }

    private void renderText(String text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Font font = Minecraft.getInstance().font;
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.08f, 0.001f);
        poseStack.scale(0.004f, 0.0045f, 0.004f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        int textWidth = font.width(text);
        float xOffset = (float)(-textWidth) / 2.0f;
        font.drawInBatch(text, xOffset, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }
}

