/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.realfilingreborn.block.entity;

import com.blocklogic.realfilingreborn.block.custom.FilingCabinetBlock;
import com.blocklogic.realfilingreborn.block.entity.ModBlockEntities;
import com.blocklogic.realfilingreborn.item.custom.FilingFolderItem;
import com.blocklogic.realfilingreborn.item.custom.NBTFilingFolderItem;
import com.blocklogic.realfilingreborn.screen.custom.FilingCabinetMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilingCabinetBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            FilingCabinetBlockEntity.this.setChanged();
            if (FilingCabinetBlockEntity.this.level != null && !FilingCabinetBlockEntity.this.level.isClientSide()) {
                FilingCabinetBlockEntity.this.level.sendBlockUpdated(FilingCabinetBlockEntity.this.getBlockPos(), FilingCabinetBlockEntity.this.getBlockState(), FilingCabinetBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final Map<Direction, IItemHandler> handlers = new HashMap<Direction, IItemHandler>();

    public FilingCabinetBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.FILING_CABINET_BE.get(), pos, blockState);
    }

    @Nullable
    public IItemHandler getCapabilityHandler(@Nullable Direction side) {
        if (side != null && this.getBlockState().getValue((Property)FilingCabinetBlock.FACING) == side) {
            return null;
        }
        return this.handlers.computeIfAbsent(side != null ? side : Direction.UP, s -> new FilingCabinetItemHandler(this, (Direction)s));
    }

    public void updateIndexLinking() {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"blockentity.realfilingreborn.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FilingCabinetMenu(i, inventory, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void onLoad() {
        super.onLoad();
        this.updateIndexLinking();
    }

    public void markForUpdate() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    private static class FilingCabinetItemHandler
    implements IItemHandler {
        private final FilingCabinetBlockEntity cabinet;
        private final Direction side;

        public FilingCabinetItemHandler(FilingCabinetBlockEntity cabinet, @Nullable Direction side) {
            this.cabinet = cabinet;
            this.side = side;
        }

        public int getSlots() {
            return 5;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                return ItemStack.EMPTY;
            }
            ItemStack folderStack = this.cabinet.inventory.getStackInSlot(slot);
            if (folderStack.getItem() instanceof FilingFolderItem) {
                FilingFolderItem.FolderContents contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents == null || contents.storedItemId().isEmpty() || contents.count() <= 0) {
                    return ItemStack.EMPTY;
                }
                ResourceLocation itemId = contents.storedItemId().get();
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                return new ItemStack((ItemLike)item, contents.count());
            }
            if (folderStack.getItem() instanceof NBTFilingFolderItem) {
                NBTFilingFolderItem.NBTFolderContents contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
                if (contents == null || contents.storedItemId().isEmpty() || contents.storedItems().isEmpty()) {
                    return ItemStack.EMPTY;
                }
                if (!contents.storedItems().isEmpty()) {
                    NBTFilingFolderItem.SerializedItemStack serializedItem = contents.storedItems().get(0);
                    ItemStack firstItem = serializedItem.stack().copy();
                    firstItem.setCount(contents.storedItems().size());
                    return firstItem;
                }
            }
            return ItemStack.EMPTY;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot < 0 || slot >= this.getSlots() || stack.isEmpty()) {
                return stack;
            }
            if (this.side != null) {
                ResourceLocation folderItemId;
                Record contents;
                ItemStack folderStack;
                int i;
                ResourceLocation stackItemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                for (i = 0; i < 5; ++i) {
                    folderStack = this.cabinet.inventory.getStackInSlot(i);
                    if (folderStack.isEmpty() || !(folderStack.getItem() instanceof FilingFolderItem) || folderStack.getItem() instanceof NBTFilingFolderItem || (contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value())) == null || ((FilingFolderItem.FolderContents)contents).storedItemId().isEmpty() || !(folderItemId = ((FilingFolderItem.FolderContents)contents).storedItemId().get()).equals((Object)stackItemId) || FilingFolderItem.hasSignificantNBT(stack)) continue;
                    int maxToAdd = Integer.MAX_VALUE - ((FilingFolderItem.FolderContents)contents).count();
                    int toAdd = Math.min(stack.getCount(), maxToAdd);
                    if (toAdd <= 0) continue;
                    if (!simulate) {
                        FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(((FilingFolderItem.FolderContents)contents).storedItemId(), ((FilingFolderItem.FolderContents)contents).count() + toAdd);
                        folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                        this.cabinet.setChanged();
                    }
                    ItemStack remaining = stack.copy();
                    remaining.shrink(toAdd);
                    return remaining;
                }
                for (i = 0; i < 5; ++i) {
                    boolean hasNBT;
                    folderStack = this.cabinet.inventory.getStackInSlot(i);
                    if (folderStack.isEmpty() || !(folderStack.getItem() instanceof NBTFilingFolderItem) || (contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value())) == null || ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().isEmpty() || !(folderItemId = ((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId().get()).equals((Object)stackItemId) || !(hasNBT = this.hasSignificantNBT(stack))) continue;
                    if (((NBTFilingFolderItem.NBTFolderContents)contents).storedItems() != null && ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems().size() >= 64) {
                        return stack;
                    }
                    if (!simulate) {
                        ArrayList<NBTFilingFolderItem.SerializedItemStack> newItems = new ArrayList<NBTFilingFolderItem.SerializedItemStack>(((NBTFilingFolderItem.NBTFolderContents)contents).storedItems() != null ? ((NBTFilingFolderItem.NBTFolderContents)contents).storedItems() : new ArrayList());
                        int availableSpace = 64 - newItems.size();
                        int itemsToAdd = Math.min(stack.getCount(), availableSpace);
                        for (int count = 0; count < itemsToAdd; ++count) {
                            ItemStack singleItem = stack.copy();
                            singleItem.setCount(1);
                            newItems.add(new NBTFilingFolderItem.SerializedItemStack(singleItem));
                        }
                        NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(((NBTFilingFolderItem.NBTFolderContents)contents).storedItemId(), newItems);
                        folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                        this.cabinet.setChanged();
                        if (itemsToAdd < stack.getCount()) {
                            ItemStack remaining = stack.copy();
                            remaining.setCount(stack.getCount() - itemsToAdd);
                            return remaining;
                        }
                    }
                    return ItemStack.EMPTY;
                }
                return stack;
            }
            ItemStack folderStack = this.cabinet.inventory.getStackInSlot(slot);
            if (folderStack.isEmpty()) {
                return stack;
            }
            if (folderStack.getItem() instanceof FilingFolderItem && !(folderStack.getItem() instanceof NBTFilingFolderItem)) {
                ResourceLocation stackItemId;
                if (FilingFolderItem.hasSignificantNBT(stack)) {
                    return stack;
                }
                FilingFolderItem.FolderContents contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents == null) {
                    contents = new FilingFolderItem.FolderContents(Optional.empty(), 0);
                }
                if (contents.storedItemId().isEmpty()) {
                    ResourceLocation newItemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    if (!simulate) {
                        int toAdd = Math.min(stack.getCount(), Integer.MAX_VALUE);
                        FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(Optional.of(newItemId), toAdd);
                        folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                        this.cabinet.setChanged();
                    }
                    ItemStack remaining = stack.copy();
                    remaining.shrink(stack.getCount());
                    return remaining;
                }
                ResourceLocation itemId = contents.storedItemId().get();
                if (!itemId.equals((Object)(stackItemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem())))) {
                    return stack;
                }
                if (contents.count() > 2147482647) {
                    return stack;
                }
                int maxToAdd = Integer.MAX_VALUE - contents.count();
                int toAdd = Math.min(stack.getCount(), maxToAdd);
                if (toAdd <= 0) {
                    return stack;
                }
                if (!simulate) {
                    FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(contents.storedItemId(), contents.count() + toAdd);
                    folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                    this.cabinet.setChanged();
                }
                ItemStack remaining = stack.copy();
                remaining.shrink(toAdd);
                return remaining;
            }
            if (folderStack.getItem() instanceof NBTFilingFolderItem) {
                ResourceLocation stackItemId;
                NBTFilingFolderItem.NBTFolderContents contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
                if (contents == null) {
                    contents = new NBTFilingFolderItem.NBTFolderContents(Optional.empty(), new ArrayList<NBTFilingFolderItem.SerializedItemStack>());
                }
                if (contents.storedItems() != null && contents.storedItems().size() >= 64) {
                    return stack;
                }
                if (contents.storedItemId().isEmpty()) {
                    if (!this.hasSignificantNBT(stack)) {
                        return stack;
                    }
                    ResourceLocation newItemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    if (!simulate) {
                        ArrayList<NBTFilingFolderItem.SerializedItemStack> newItems = new ArrayList<NBTFilingFolderItem.SerializedItemStack>();
                        int availableSpace = 64;
                        int itemsToAdd = Math.min(stack.getCount(), availableSpace);
                        for (int count = 0; count < itemsToAdd; ++count) {
                            ItemStack singleItem = stack.copy();
                            singleItem.setCount(1);
                            newItems.add(new NBTFilingFolderItem.SerializedItemStack(singleItem));
                        }
                        NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(Optional.of(newItemId), newItems);
                        folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                        this.cabinet.setChanged();
                        if (itemsToAdd < stack.getCount()) {
                            ItemStack remaining = stack.copy();
                            remaining.setCount(stack.getCount() - itemsToAdd);
                            return remaining;
                        }
                    }
                    return ItemStack.EMPTY;
                }
                ResourceLocation itemId = contents.storedItemId().get();
                if (!itemId.equals((Object)(stackItemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem())))) {
                    return stack;
                }
                if (!this.hasSignificantNBT(stack)) {
                    return stack;
                }
                if (!simulate) {
                    ArrayList<NBTFilingFolderItem.SerializedItemStack> newItems = new ArrayList<NBTFilingFolderItem.SerializedItemStack>(contents.storedItems() != null ? contents.storedItems() : new ArrayList());
                    int availableSpace = 64 - newItems.size();
                    int itemsToAdd = Math.min(stack.getCount(), availableSpace);
                    for (int count = 0; count < itemsToAdd; ++count) {
                        ItemStack singleItem = stack.copy();
                        singleItem.setCount(1);
                        newItems.add(new NBTFilingFolderItem.SerializedItemStack(singleItem));
                    }
                    NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(contents.storedItemId(), newItems);
                    folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                    this.cabinet.setChanged();
                    if (itemsToAdd < stack.getCount()) {
                        ItemStack remaining = stack.copy();
                        remaining.setCount(stack.getCount() - itemsToAdd);
                        return remaining;
                    }
                }
                return ItemStack.EMPTY;
            }
            return stack;
        }

        private boolean hasSignificantNBT(ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            if (stack.isDamaged()) {
                return true;
            }
            ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            if (enchantments != null && !enchantments.isEmpty()) {
                return true;
            }
            ItemEnchantments stored = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
            if (stored != null && !stored.isEmpty()) {
                return true;
            }
            if (stack.get(DataComponents.CUSTOM_NAME) != null) {
                return true;
            }
            ItemLore lore = (ItemLore)stack.get(DataComponents.LORE);
            if (lore != null && !lore.lines().isEmpty()) {
                return true;
            }
            PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            return potion != null && (!potion.customEffects().isEmpty() || !potion.potion().isEmpty());
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < 0 || slot >= this.getSlots() || amount <= 0) {
                return ItemStack.EMPTY;
            }
            ItemStack folderStack = this.cabinet.inventory.getStackInSlot(slot);
            if (folderStack.getItem() instanceof FilingFolderItem) {
                FilingFolderItem.FolderContents contents = (FilingFolderItem.FolderContents)folderStack.get((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value());
                if (contents == null || contents.storedItemId().isEmpty() || contents.count() <= 0) {
                    return ItemStack.EMPTY;
                }
                ResourceLocation itemId = contents.storedItemId().get();
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                ItemStack result = new ItemStack((ItemLike)item, 1);
                int maxStackSize = item.getMaxStackSize(result);
                int extractAmount = Math.min(Math.min(contents.count(), amount), maxStackSize);
                if (extractAmount <= 0) {
                    return ItemStack.EMPTY;
                }
                result.setCount(extractAmount);
                if (!simulate) {
                    int newCount = contents.count() - extractAmount;
                    FilingFolderItem.FolderContents newContents = new FilingFolderItem.FolderContents(contents.storedItemId(), newCount);
                    folderStack.set((DataComponentType)FilingFolderItem.FOLDER_CONTENTS.value(), (Object)newContents);
                    this.cabinet.setChanged();
                }
                return result;
            }
            if (folderStack.getItem() instanceof NBTFilingFolderItem) {
                NBTFilingFolderItem.NBTFolderContents contents = (NBTFilingFolderItem.NBTFolderContents)folderStack.get((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value());
                if (contents == null || contents.storedItemId().isEmpty() || contents.storedItems().isEmpty()) {
                    return ItemStack.EMPTY;
                }
                ArrayList<NBTFilingFolderItem.SerializedItemStack> items = new ArrayList<NBTFilingFolderItem.SerializedItemStack>(contents.storedItems());
                int extractAmount = Math.min(amount, items.size());
                if (extractAmount <= 0) {
                    return ItemStack.EMPTY;
                }
                NBTFilingFolderItem.SerializedItemStack serializedItem = (NBTFilingFolderItem.SerializedItemStack)items.get(items.size() - 1);
                ItemStack extracted = serializedItem.stack().copy();
                int actualExtract = extracted.isStackable() ? extractAmount : 1;
                extracted.setCount(actualExtract);
                if (!simulate) {
                    for (int i = 0; i < actualExtract; ++i) {
                        if (items.isEmpty()) continue;
                        items.remove(items.size() - 1);
                    }
                    NBTFilingFolderItem.NBTFolderContents newContents = new NBTFilingFolderItem.NBTFolderContents(contents.storedItemId(), items);
                    folderStack.set((DataComponentType)NBTFilingFolderItem.NBT_FOLDER_CONTENTS.value(), (Object)newContents);
                    this.cabinet.setChanged();
                }
                return extracted;
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getItem() instanceof FilingFolderItem;
        }
    }
}

