/*
 * Decompiled with CFR 0.152.
 */
package lolous.studio.sunshine_rewrite.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.impl.controller.IntegerSliderControllerBuilderImpl;
import dev.isxander.yacl3.impl.controller.TickBoxControllerBuilderImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SunshineConfig {
    public static final SunshineConfig DEFAULT = new SunshineConfig();
    public final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("sunshine.json");
    public boolean freezeTime = false;
    public int timeTick = 6000;
    public boolean customTimeCycle = false;
    public int customTimeCycleSpeed = 20;
    public int shortcut1TimeTick = 0;
    public int shortcut2TimeTick = 6000;
    public int shortcut3TimeTick = 12000;

    public void save() {
        try {
            JsonObject config = new JsonObject();
            config.addProperty("timeTick", (Number)this.timeTick);
            config.addProperty("freezeTime", Boolean.valueOf(this.freezeTime));
            config.addProperty("customTimeCycle", Boolean.valueOf(this.customTimeCycle));
            config.addProperty("customTimeCycleSpeed", (Number)this.customTimeCycleSpeed);
            config.addProperty("shortcut1TimeTick", (Number)this.shortcut1TimeTick);
            config.addProperty("shortcut2TimeTick", (Number)this.shortcut2TimeTick);
            config.addProperty("shortcut3TimeTick", (Number)this.shortcut3TimeTick);
            Files.write(this.configFile, this.gson.toJson((JsonElement)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load() {
        try {
            if (!Files.exists(this.configFile, new LinkOption[0])) {
                this.save();
                return;
            }
            JsonObject config = (JsonObject)this.gson.fromJson(new String(Files.readAllBytes(this.configFile)), JsonObject.class);
            if (config.has("timeTick")) {
                this.timeTick = config.getAsJsonPrimitive("timeTick").getAsInt();
            }
            if (config.has("freezeTime")) {
                this.freezeTime = config.getAsJsonPrimitive("freezeTime").getAsBoolean();
            }
            if (config.has("customTimeCycle")) {
                this.customTimeCycle = config.getAsJsonPrimitive("customTimeCycle").getAsBoolean();
            }
            if (config.has("customTimeCycleSpeed")) {
                this.customTimeCycleSpeed = config.getAsJsonPrimitive("customTimeCycleSpeed").getAsInt();
            }
            if (config.has("shortcut1TimeTick")) {
                this.shortcut1TimeTick = config.getAsJsonPrimitive("shortcut1TimeTick").getAsInt();
            }
            if (config.has("shortcut2TimeTick")) {
                this.shortcut2TimeTick = config.getAsJsonPrimitive("shortcut2TimeTick").getAsInt();
            }
            if (config.has("shortcut3TimeTick")) {
                this.shortcut3TimeTick = config.getAsJsonPrimitive("shortcut3TimeTick").getAsInt();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class_437 makeScreen(class_437 parent) {
        Option freezeTimeOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.main.freezeTime")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sunshine.options.main.freezeTime.tooltip")})).binding((Object)true, () -> this.freezeTime, value -> {
            this.freezeTime = value;
        }).controller(TickBoxControllerBuilderImpl::new).build();
        Option timeTickOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.main.timeTick")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sunshine.options.main.timeTick.tooltip")})).binding((Object)6000, () -> this.timeTick, value -> {
            this.timeTick = value;
        }).controller(opt -> ((IntegerSliderControllerBuilder)new IntegerSliderControllerBuilderImpl(opt).range(Integer.valueOf(0), Integer.valueOf(24000)).step((Number)1000)).formatValue(value -> class_2561.method_30163((String)(value + " ticks")))).build();
        Option customTimeCycleOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.main.customTimeCycle")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sunshine.options.main.customTimeCycle.tooltip")})).binding((Object)false, () -> this.customTimeCycle, value -> {
            this.customTimeCycle = value;
        }).controller(TickBoxControllerBuilderImpl::new).build();
        Option customTimeCycleSpeedOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.main.customTimeCycleSpeed")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sunshine.options.main.customTimeCycleSpeed.tooltip")})).binding((Object)20, () -> this.customTimeCycleSpeed, value -> {
            this.customTimeCycleSpeed = value;
        }).controller(opt -> ((IntegerSliderControllerBuilder)new IntegerSliderControllerBuilderImpl(opt).range(Integer.valueOf(-1000), Integer.valueOf(1000)).step((Number)1)).formatValue(value -> class_2561.method_30163((String)(value + " ticks per tick")))).build();
        ConfigCategory sunshineCategory = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.main.title")).option(freezeTimeOption).option(timeTickOption).option(customTimeCycleOption).option(customTimeCycleSpeedOption).build();
        Option shortcut1TimeTickOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.shortcuts.shortcut1")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sunshine.options.shortcuts.shortcut1.tooltip")})).binding((Object)6000, () -> this.shortcut1TimeTick, value -> {
            this.shortcut1TimeTick = value;
        }).controller(opt -> ((IntegerSliderControllerBuilder)new IntegerSliderControllerBuilderImpl(opt).range(Integer.valueOf(0), Integer.valueOf(24000)).step((Number)1000)).formatValue(value -> class_2561.method_30163((String)(value + " ticks")))).build();
        Option shortcut2TimeTickOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.shortcuts.shortcut2")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sunshine.options.shortcuts.shortcut2.tooltip")})).binding((Object)6000, () -> this.shortcut2TimeTick, value -> {
            this.shortcut2TimeTick = value;
        }).controller(opt -> ((IntegerSliderControllerBuilder)new IntegerSliderControllerBuilderImpl(opt).range(Integer.valueOf(0), Integer.valueOf(24000)).step((Number)1000)).formatValue(value -> class_2561.method_30163((String)(value + " ticks")))).build();
        Option shortcut3TimeTickOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.shortcuts.shortcut3")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sunshine.options.shortcuts.shortcut3.tooltip")})).binding((Object)6000, () -> this.shortcut3TimeTick, value -> {
            this.shortcut3TimeTick = value;
        }).controller(opt -> ((IntegerSliderControllerBuilder)new IntegerSliderControllerBuilderImpl(opt).range(Integer.valueOf(0), Integer.valueOf(24000)).step((Number)1000)).formatValue(value -> class_2561.method_30163((String)(value + " ticks")))).build();
        ConfigCategory shortcutsCategory = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"sunshine.options.shortcuts.title")).option(shortcut1TimeTickOption).option(shortcut2TimeTickOption).option(shortcut3TimeTickOption).build();
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"sunshine.title")).category(sunshineCategory).category(shortcutsCategory).save(this::save).build().generateScreen(parent);
    }
}

