package com.thedeathlycow.immersive.storms;

import com.thedeathlycow.immersive.storms.registry.ISParticleTypes;
import com.thedeathlycow.immersive.storms.registry.ISSoundEvents;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.file.Path;

public class ImmersiveStorms implements ModInitializer {
    public static final String MOD_ID = "immersive-storms";

    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    @Override
    public void onInitialize() {
        ISParticleTypes.initialize();
        ISSoundEvents.initialize();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
    }
}