package com.thedeathlycow.immersive.storms;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import com.thedeathlycow.immersive.storms.config.ImmersiveStormsConfig;
import com.thedeathlycow.immersive.storms.config.SandstormConfig;
import com.thedeathlycow.immersive.storms.config.Translate;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ImmersiveStormsModMenu implements ModMenuApi {
    private static final String GENERAL_PREFIX = Translate.prefixKey(ImmersiveStormsConfig.HANDLER);
    private static final String SANDSTORM_PREFIX = Translate.prefixKey(SandstormConfig.HANDLER);
    public static final String TITLE = GENERAL_PREFIX + ".title";
    public static final String GENERAL_CATEGORY = GENERAL_PREFIX + ".category.general";
    public static final String SANDSTORM_CATEGORY = SANDSTORM_PREFIX + ".category.sandstorms";
    public static final String GENERAL_CATEGORY_DESC = GENERAL_PREFIX + ".category.desc";
    public static final String SANDSTORM_CATEGORY_DESC = SANDSTORM_PREFIX + ".category.desc";

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> YetAnotherConfigLib.createBuilder()
                .title(class_2561.method_43470("Immersive Storms Test"))
                .category(
                        ConfigCategory.createBuilder()
                                .name(class_2561.method_43471(TITLE))
                                .option(ButtonOption.createBuilder()
                                        .name(class_2561.method_43471(GENERAL_CATEGORY))
                                        .description(
                                                OptionDescription.createBuilder()
                                                        .text(class_2561.method_43471(GENERAL_CATEGORY_DESC))
                                                        .build()
                                        )
                                        .text(class_2561.method_43470(""))
                                        .action((yaclScreen, buttonOption) -> {
                                            class_310.method_1551()
                                                    .method_1507(ImmersiveStormsConfig.HANDLER
                                                            .generateGui()
                                                            .generateScreen(yaclScreen));
                                        }).build())
                                .option(ButtonOption.createBuilder()
                                        .name(class_2561.method_43471(SANDSTORM_CATEGORY))
                                        .description(
                                                OptionDescription.createBuilder()
                                                        .text(class_2561.method_43471(SANDSTORM_CATEGORY_DESC))
                                                        .build()
                                        )
                                        .text(class_2561.method_43470(""))
                                        .action((yaclScreen, buttonOption) -> {
                                            class_310.method_1551()
                                                    .method_1507(SandstormConfig.HANDLER
                                                            .generateGui()
                                                            .generateScreen(yaclScreen));
                                        }).build())
                                .build()
                )
                .build()
                .generateScreen(parent);
    }
}