package com.thedeathlycow.immersive.storms.mixin.client;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.thedeathlycow.immersive.storms.world.StormFogModifier;
import net.minecraft.class_11397;
import net.minecraft.class_11398;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_7285;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_11397.class)
public abstract class StandardFogModifierMixin {
    @WrapOperation(
            method = "getFogColor",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/CubicSampler;sampleColor(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/CubicSampler$RgbFetcher;)Lnet/minecraft/util/math/Vec3d;"
            )
    )
    protected class_243 modifyBaseFogColor(
            class_243 pos,
            class_6491.class_4859 rgbFetcher,
            Operation<class_243> original,
            @Local(argsOnly = true) class_638 world
    ) {
        return original.call(pos, rgbFetcher);
    }

    @Mixin(class_11398.class)
    private static class AtmosphericFogModifierMixin extends StandardFogModifierMixin {
        @Override
        protected class_243 modifyBaseFogColor(class_243 pos, class_6491.class_4859 rgbFetcher, Operation<class_243> original, class_638 world) {
            if (StormFogModifier.shouldApply(world)) {
                return StormFogModifier.sampleWeatherFogColor(world, pos, class_1959::method_24376);
            } else {
                return super.modifyBaseFogColor(pos, rgbFetcher, original, world);
            }
        }

        @WrapMethod(
                method = "applyStartEndModifier"
        )
        private void modifyFogDistance(
                class_7285 data,
                class_1297 cameraEntity,
                class_2338 cameraPos,
                class_638 world,
                float viewDistance,
                class_9779 tickCounter,
                Operation<Void> original
        ) {
            original.call(data, cameraEntity, cameraPos, world, viewDistance, tickCounter);

            if (StormFogModifier.shouldApply(world)) {
                StormFogModifier.applyStartEndModifier(data, cameraEntity.method_33571(), world, tickCounter);
            }
        }
    }
}