package com.thedeathlycow.immersive.storms.util;

import com.thedeathlycow.immersive.storms.registry.ISBiomeTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiPredicate;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_3542;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public enum WeatherEffectType implements class_3542 {
    NONE,
    SANDSTORM(
            "sandstorm",
            ISBiomeTags.HAS_SANDSTORMS,
            0xd96e38,
            new WeatherData(WeatherData.LIGHT_FOG, true),
            new WeatherData(WeatherData.THICK_FOG, true),
            false
    ),
    BLIZZARD(
            "blizzard",
            ISBiomeTags.HAS_BLIZZARDS,
            0xBBBBBB,
            null,
            new WeatherData(WeatherData.LIGHT_FOG, false),
            false
    ),
    DENSE_FOG(
            "dense_fog",
            ISBiomeTags.HAS_DENSE_FOG,
            -1,
            new WeatherData(WeatherData.LIGHT_FOG, false),
            new WeatherData(WeatherData.THICK_FOG, false),
            true
    );

    private final String name;

    @Nullable
    private final class_6862<class_1959> biomeTag;

    private final int color;

    @Nullable
    private final WeatherEffectType.WeatherData rainWeatherData;

    @Nullable
    private final WeatherEffectType.WeatherData thunderWeatherData;

    private final boolean allowedWithRain;

    WeatherEffectType() {
        this("none", null, -1, null, null, true);
    }

    WeatherEffectType(
            String name,
            @Nullable class_6862<class_1959> biomeTag,
            int color,
            @Nullable WeatherEffectType.WeatherData rainWeatherData,
            @Nullable WeatherEffectType.WeatherData thunderWeatherData,
            boolean allowedWithRain
    ) {
        this.name = name;
        this.biomeTag = biomeTag;
        this.color = color;
        this.rainWeatherData = rainWeatherData;
        this.thunderWeatherData = thunderWeatherData;
        this.allowedWithRain = allowedWithRain;
    }

    @Override
    public String method_15434() {
        return this.name;
    }

    @Nullable
    public class_6862<class_1959> getBiomeTag() {
        return biomeTag;
    }

    public int getColor() {
        return color;
    }

    @Nullable
    public WeatherEffectType.WeatherData getWeatherData(class_1937 world) {
        if (this.thunderWeatherData != null && world.method_8546()) {
            return this.thunderWeatherData;
        } else if (world.method_8419()) {
            return this.rainWeatherData;
        } else {
            return null;
        }
    }

    @Nullable
    public WeatherEffectType.WeatherData getRainWeatherData() {
        return rainWeatherData;
    }

    @Nullable
    public WeatherEffectType.WeatherData getThunderWeatherData() {
        return thunderWeatherData;
    }

    public boolean allowedWithRain() {
        return this.allowedWithRain;
    }

    @ApiStatus.Internal
    public static WeatherEffectType forBiome(class_6880<class_1959> biome, BiPredicate<WeatherEffectType, class_6880<class_1959>> allowed) {
        for (WeatherEffectType value : values()) {
            if (allowed.test(value, biome)) {
                return value;
            }
        }

        return NONE;
    }

    public record WeatherData(
            class_243 fogDistance,
            boolean windy
    ) {
        private static final class_243 LIGHT_FOG = new class_243(32, 64, 0);
        private static final class_243 THICK_FOG = new class_243(16, 32, 0);
    }
}