package com.thedeathlycow.immersive.storms.util;

import java.util.function.BiPredicate;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_6880;

public final class WeatherEffects {
    public static WeatherEffectType getCurrentType(
            class_1937 world,
            class_2338 pos,
            boolean aboveSurface,
            BiPredicate<WeatherEffectType, class_6880<class_1959>> tagInclusion
    ) {
        if (!isWeatherEffected(world, pos, aboveSurface)) {
            return WeatherEffectType.NONE;
        }

        class_6880<class_1959> biome = world.method_22385().method_27344(pos);
        WeatherEffectType type = WeatherEffectType.forBiome(biome, tagInclusion);

        if (!type.allowedWithRain() && aboveSurface && world.method_8520(pos)) {
            return WeatherEffectType.NONE;
        }

        return type;
    }

    public static WeatherEffectType getCurrentType(
            class_1937 world,
            class_2338 pos,
            boolean aboveSurface
    ) {
        return getCurrentType(
                world,
                pos,
                aboveSurface,
                (type, biome) -> type.getBiomeTag() != null && biome.method_40220(type.getBiomeTag())
        );
    }

    private static boolean isWeatherEffected(
            class_1937 world,
            class_2338 pos,
            boolean aboveSurface
    ) {
        if (!world.method_8419()) {
            return false;
        } else if (aboveSurface && !world.method_8311(pos)) {
            return false;
        } else if (aboveSurface && world.method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return false;
        } else {
            return true;
        }
    }

    private WeatherEffects() {

    }
}