package com.thedeathlycow.immersive.storms.util;

import com.thedeathlycow.immersive.storms.ImmersiveStormsClient;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;

public final class WeatherEffectsClient {
    public static WeatherEffectType getCurrentType(
            class_1937 world,
            class_2338 pos,
            boolean aboveSurface
    ) {
        return WeatherEffects.getCurrentType(
                world,
                pos,
                aboveSurface,
                WeatherEffectsClient::isWeatherEffectTypeEnabled
        );
    }

    public static boolean isWeatherEffectTypeEnabled(WeatherEffectType type, class_6880<class_1959> biome) {
        return type.getBiomeTag() != null
                && ImmersiveStormsClient.getConfig().isEnabled(type)
                && ClientTags.isInWithLocalFallback(type.getBiomeTag(), biome);
    }

    private WeatherEffectsClient() {

    }
}