package com.thedeathlycow.immersive.storms.world;

import com.google.common.base.Suppliers;
import com.thedeathlycow.immersive.storms.ImmersiveStormsClient;
import com.thedeathlycow.immersive.storms.config.ImmersiveStormsConfig;
import com.thedeathlycow.immersive.storms.particle.DustGrainParticleEffect;
import com.thedeathlycow.immersive.storms.registry.ISBiomeTags;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

import java.util.function.Supplier;

public class BiomeWindEffects implements ClientTickEvents.EndWorldTick {
    private static final int PARTICLES_PER_TICK = 3;
    private static final float PARTICLE_SCALE = 4f;
    private static final Vector2d PARTICLE_VELOCITY = new Vector2d(-1.0, -1.0).normalize(0.6);
    private static final float PARTICLE_CHANCE = 1f / 5f;
    private static final float SOUND_CHANCE = 1f / 100f;

    @Override
    public void onEndTick(class_638 clientWorld) {
        if (clientWorld.method_54719().method_54754()) {
            return;
        }

        ImmersiveStormsConfig config = ImmersiveStormsClient.getConfig();
        boolean enableParticles = config.isEnableAmbientWindParticles();
        boolean enableSounds = config.isEnableAmbientWindSounds();

        if (!(enableParticles || enableSounds)) {
            return;
        }

        final class_310 gameClient = class_310.method_1551();
        final class_4184 camera = gameClient.field_1773.method_19418();
        if (camera == null) {
            return;
        }

        final class_2338 cameraPos = camera.method_19328();
        final class_2338.class_2339 pos = new class_2338.class_2339();
        final int particleRenderDistance = 20;

        final class_5819 random = clientWorld.method_8409();

        for (int i = 0; i < PARTICLES_PER_TICK; i++) {
            class_6880<class_1959> biome = setRandomTopPos(clientWorld, cameraPos, random, particleRenderDistance, pos);

            ParticleColor color = ParticleColor.forBiome(biome);

            if (color != null) {
                addParticleAndSound(clientWorld, config, random, color, pos, cameraPos);
            }
        }
    }

    private static void addParticleAndSound(
            class_638 clientWorld,
            ImmersiveStormsConfig config,
            class_5819 random,
            ParticleColor color,
            class_2338.class_2339 pos,
            class_2338 cameraPos
    ) {
        boolean enableParticles = config.isEnableAmbientWindParticles();
        boolean enableSounds = config.isEnableAmbientWindSounds();

        boolean addParticle = enableParticles
                && random.method_43057() < PARTICLE_CHANCE * config.getWindParticleChanceMultiplier();

        if (addParticle) {
            class_2394 particle = color.getParticle();
            double speed = random.method_43385(1.0, 0.5);

            clientWorld.method_8406(
                    particle,
                    pos.method_10263() + random.method_43058(),
                    pos.method_10264() + random.method_43058() * 0.2 + 0.15,
                    pos.method_10260() + random.method_43058(),
                    speed * PARTICLE_VELOCITY.x, 0, speed * PARTICLE_VELOCITY.y
            );
        }

        boolean tryPlaySound = enableSounds
                && !clientWorld.method_8419()
                && random.method_43057() < SOUND_CHANCE;

        if (tryPlaySound) {
            final int soundDistance = 5;

            class_6880<class_1959> biome = setRandomTopPos(clientWorld, cameraPos, random, soundDistance, pos);


            boolean canPlaySound = Math.abs(pos.method_10264() - cameraPos.method_10264()) <= soundDistance * 2;
            if (canPlaySound) {
                clientWorld.method_8486(
                        pos.method_10263(), pos.method_10264(), pos.method_10260(),
                        class_3417.field_59645, // this is actually a generic wind sound
                        class_3419.field_15256,
                        1.0f, 1.0f,
                        true
                );
            }
        }
    }

    private static class_6880<class_1959> setRandomTopPos(
            class_638 world,
            class_2338 center,
            class_5819 random,
            int offset,
            class_2338.class_2339 out
    ) {
        int x = center.method_10263() + random.method_39332(-offset, offset);
        int z = center.method_10260() + random.method_39332(-offset, offset);
        int y = world.method_8624(class_2902.class_2903.field_13203, x, z);
        out.method_10103(x, y, z);
        return world.method_22385().method_27344(out);
    }

    private enum ParticleColor {
        SNOWY(ISBiomeTags.HAS_BLIZZARDS, () -> new DustGrainParticleEffect(
                0xffffff,
                PARTICLE_SCALE
        )),
        SANDY(ISBiomeTags.HAS_SANDSTORMS, () -> new DustGrainParticleEffect(
                SandstormParticles.COLOR,
                PARTICLE_SCALE
        )),
        ROCKY(ISBiomeTags.IS_WINDY, () -> new DustGrainParticleEffect(
                0x888888,
                PARTICLE_SCALE
        ));

        private final class_6862<class_1959> tag;
        private final Supplier<class_2394> particle;

        ParticleColor(class_6862<class_1959> tag, Supplier<class_2394> particle) {
            this.tag = tag;
            this.particle = Suppliers.memoize(particle::get);
        }

        public class_2394 getParticle() {
            return particle.get();
        }

        @Nullable
        public static ParticleColor forBiome(class_6880<class_1959> biome) {
            if (ClientTags.isInWithLocalFallback(ISBiomeTags.IS_WINDY, biome)) {
                for (ParticleColor value : values()) {
                    if (ClientTags.isInWithLocalFallback(value.tag, biome)) {
                        return value;
                    }
                }

                return ROCKY;
            }

            return null;
        }
    }
}