package com.thedeathlycow.immersive.storms.world;

import com.thedeathlycow.immersive.storms.ImmersiveStormsClient;
import com.thedeathlycow.immersive.storms.util.WeatherEffectType;
import com.thedeathlycow.immersive.storms.config.ImmersiveStormsConfig;
import com.thedeathlycow.immersive.storms.config.SandstormConfig;
import com.thedeathlycow.immersive.storms.particle.DustGrainParticleEffect;
import com.thedeathlycow.immersive.storms.registry.ISBiomeTags;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.joml.Vector3f;

import java.util.Objects;

public final class SandstormParticles implements ClientTickEvents.EndWorldTick {
    public static final Vector3f COLOR = class_243.method_24457(0xD9AA84).method_46409();

    private static final float PARTICLE_SCALE = 10f;
    private static final float PARTICLE_VELOCITY = -1f;
    private static final float BASE_PARTICLE_CHANCE = 1f / 60f;

    @Override
    public void onEndTick(class_638 clientWorld) {
        if (!clientWorld.method_8419() || clientWorld.method_54719().method_54754()) {
            return;
        }

        ImmersiveStormsConfig config = ImmersiveStormsClient.getConfig();
        SandstormConfig sandstormConfig = config.getSandstorm();
        final int renderDistance = sandstormConfig.getSandstormParticleRenderDistance();
        boolean enabled = sandstormConfig.isEnableSandstormParticles()
                && config.isEnabled(WeatherEffectType.SANDSTORM)
                && renderDistance > 0;

        if (!enabled) {
            return;
        }

        final class_310 gameClient = class_310.method_1551();
        final class_4184 camera = gameClient.field_1773.method_19418();
        if (camera == null) {
            return; // no camera for whatever reason
        }

        // main particle loop
        final class_2338 cameraPos = camera.method_19328();
        final class_2338.class_2339 pos = new class_2338.class_2339();
        final class_2394 particle = new DustGrainParticleEffect(COLOR, PARTICLE_SCALE);
        final float rarity = BASE_PARTICLE_CHANCE * sandstormConfig.getSandstormParticleDensityMultiplier();
        final int cameraY = cameraPos.method_10264();
        final int xOffset = renderDistance / 2;

        for (int x = cameraPos.method_10263() - renderDistance; x < cameraPos.method_10263() + renderDistance; x++) {
            for (int z = cameraPos.method_10260() - renderDistance; z < cameraPos.method_10260() + renderDistance; z++) {
                // adjust to account for the fact that particles travel along the x-axis
                // makes the area the particles come from look less empty
                int adjustedX = x + xOffset;

                int y = cameraY + clientWorld.field_9229.method_39332(-renderDistance / 2, (renderDistance + 1) / 2);
                y = Math.max(y, clientWorld.method_8624(class_2902.class_2903.field_13197, adjustedX, z));

                pos.method_10103(adjustedX, y, z);
                addParticle(clientWorld, particle, pos, rarity);
            }
        }
    }

    private static void addParticle(class_638 world, class_2394 particle, class_2338 pos, float rarity) {
        boolean addParticle = world.field_9229.method_43057() < rarity
                && !world.method_8520(pos) // for compatibility with seasons mods
                && ClientTags.isInWithLocalFallback(ISBiomeTags.HAS_SANDSTORMS, world.method_23753(pos)); // faster than checking the weather effects api

        if (addParticle) {
            world.method_8406(
                    particle,
                    pos.method_10263() + world.field_9229.method_43058(),
                    pos.method_10264() + world.field_9229.method_43058(),
                    pos.method_10260() + world.field_9229.method_43058(),
                    PARTICLE_VELOCITY, 0, 0
            );
        }
    }
}