package com.thedeathlycow.immersive.storms.world;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.config.IDhApiConfig;
import com.thedeathlycow.immersive.storms.ImmersiveStormsClient;
import com.thedeathlycow.immersive.storms.config.ImmersiveStormsConfig;
import com.thedeathlycow.immersive.storms.mixin.client.WorldAccessor;
import com.thedeathlycow.immersive.storms.util.ISMath;
import com.thedeathlycow.immersive.storms.util.WeatherEffectType;
import com.thedeathlycow.immersive.storms.util.WeatherEffectsClient;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_6880;
import net.minecraft.class_7285;
import net.minecraft.class_9779;

public final class StormFogModifier {
    public static class_243 sampleWeatherFogColor(
            class_638 world,
            class_243 pos,
            ToIntFunction<class_1959> biomeColorSupplier
    ) {
        final float rainGradient = world.method_8430(1f);

        return class_6491.method_24895(
                pos,
                (x, y, z) -> {
                    class_6880<class_1959> biome = world.method_22385().method_24854(x, y, z);
                    WeatherEffectType sampledType = WeatherEffectType.forBiome(biome, WeatherEffectsClient::isWeatherEffectTypeEnabled);

                    class_243 biomeColor = class_243.method_24457(biomeColorSupplier.applyAsInt(biome.comp_349()));
                    int color = sampledType.getColor();

                    if (color >= 0) {
                        return ISMath.lerp(rainGradient, biomeColor, class_243.method_24457(color));
                    } else {
                        return biomeColor;
                    }
                }
        );
    }

    public static void applyStartEndModifier(
            class_7285 data,
            class_243 cameraPos,
            class_638 world,
            class_9779 tickCounter
    ) {
        ImmersiveStormsConfig config = ImmersiveStormsClient.getConfig();

        final float tickProgress = tickCounter.method_60637(false);
        final float rainGradient = world.method_8430(tickProgress);
        final float thunderGradient = world.method_8478(tickProgress);

        var baseRadius = new class_243(data.field_60582, data.field_60584, 0);

        class_243 rainDistance = lerpFogDistance(cameraPos, world, baseRadius, WeatherEffectType::getRainWeatherData);

        class_243 thunderDistance = thunderGradient > 0
                ? lerpFogDistance(cameraPos, world, baseRadius, WeatherEffectType::getThunderWeatherData)
                : null;

        updateFogRadius(data, rainDistance, thunderDistance, rainGradient, thunderGradient, config);
    }

    public static boolean shouldApply(class_1937 world) {
        ImmersiveStormsConfig config = ImmersiveStormsClient.getConfig();
        return config.isEnableFogChanges()
                && world.method_8430(1f) > 0f
                && ((WorldAccessor) world).invokeCanHaveWeather();
    }

    private static class_243 lerpFogDistance(
            class_243 pos,
            class_1937 world,
            class_243 baseRadius,
            Function<WeatherEffectType, WeatherEffectType.WeatherData> fogDataSupplier
    ) {
        var samplePos = new class_2338.class_2339();
        final int undergroundFogCutoff = world.method_8615();

        // tri lerp fog distances to make less jarring biome transition
        // start is stored in X and end in Y
        return class_6491.method_24895(pos, (x, y, z) -> {
            samplePos.method_10103(x, y, z);

            if (y < undergroundFogCutoff) {
                return baseRadius;
            }

            WeatherEffectType sampledType = WeatherEffectsClient.getCurrentType(world, samplePos, false);

            WeatherEffectType.WeatherData fogData = fogDataSupplier.apply(sampledType);
            if (fogData != null) {
                return fogData.fogDistance();
            }

            return baseRadius;
        });
    }

    private static void updateFogRadius(
            class_7285 data,
            class_243 rainDistance,
            @Nullable class_243 thunderDistance,
            float rainGradient,
            float thunderGradient,
            ImmersiveStormsConfig config
    ) {
        float fogEnd = class_3532.method_16439(rainGradient, data.field_60584, (float) rainDistance.field_1351);

        if (thunderDistance != null) {
            fogEnd = class_3532.method_16439(thunderGradient, fogEnd, (float) thunderDistance.field_1351);
        }

        fogEnd *= config.getFogDistanceMultiplier();

        float reduction = fogEnd / data.field_60584;

        if (reduction < 1.0f) {
            data.field_60584 = fogEnd;
            data.field_60099 *= reduction;
            data.field_60100 *= reduction;
        }

        if (ImmersiveStormsClient.isDistantHorizonsLoaded()) {
            setFogDistanceForDistantHorizons(reduction);
        }
    }

    private static void setFogDistanceForDistantHorizons(double reduction) {
        IDhApiConfig config = DhApi.Delayed.configs;
        if (config != null) {
            if (reduction < 1.0) {
                config.graphics().fog().farFog().farFogStartDistance().setValue(reduction * 0.1);
                config.graphics().fog().farFog().farFogEndDistance().setValue(reduction * 0.1);
                config.graphics().fog().enableVanillaFog().setValue(true);
            } else {
                config.graphics().fog().farFog().farFogStartDistance().clearValue();
                config.graphics().fog().farFog().farFogEndDistance().clearValue();
                config.graphics().fog().enableVanillaFog().clearValue();
            }
        }
    }

    private StormFogModifier() {

    }
}