package dev.mariany.improvedcombat;

import dev.mariany.improvedcombat.datagen.*;
import dev.mariany.improvedcombat.enchantment.ICEnchantments;
import dev.mariany.improvedcombat.entity.damage.ICDamageTypes;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ImprovedCombatDataGenerator implements DataGeneratorEntrypoint {
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ICItemTagProvider::new);
        pack.addProvider(ICEnchantmentProvider::new);
        pack.addProvider(ICEnchantmentTagProvider::new);
        pack.addProvider(ICDamageTypeProvider::new);
        pack.addProvider(ICDamageTypeTagProvider::new);
    }

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41265, ICEnchantments::bootstrap);
        registryBuilder.method_46777(class_7924.field_42534, ICDamageTypes::bootstrap);
    }

    @Nullable
    public String getEffectiveModId() {
        return ImprovedCombat.MOD_ID;
    }
}
