package dev.mariany.improvedcombat.client.render.entity;

import dev.mariany.improvedcombat.client.render.entity.state.ThrownAxeEntityRenderState;
import dev.mariany.improvedcombat.entity.custom.ThrownAxeEntity;
import dev.mariany.improvedcombat.tag.ICTags;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_916;

public class ThrownAxeEntityRenderer extends class_897<ThrownAxeEntity, ThrownAxeEntityRenderState> {
    private final class_5819 random = class_5819.method_43047();
    private final class_10442 itemModelManager;

    public ThrownAxeEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.itemModelManager = context.method_65566();
    }

    @Override
    public ThrownAxeEntityRenderState method_55269() {
        return new ThrownAxeEntityRenderState();
    }

    @Override
    public void updateRenderState(
            ThrownAxeEntity thrownAxeEntity,
            ThrownAxeEntityRenderState thrownAxeEntityRenderState,
            float tickProgress
    ) {
        super.method_62354(thrownAxeEntity, thrownAxeEntityRenderState, tickProgress);
        thrownAxeEntityRenderState.yaw = thrownAxeEntity.method_61415(tickProgress);
        thrownAxeEntityRenderState.pitch = thrownAxeEntity.method_61414(tickProgress);
        thrownAxeEntityRenderState.enchanted = thrownAxeEntity.isEnchanted();
        thrownAxeEntityRenderState.rightFacing = thrownAxeEntity.method_54759().method_31573(ICTags.Items.RIGHT_FACING);
        thrownAxeEntityRenderState.spinDuration = thrownAxeEntity.getSpinDuration();
        thrownAxeEntityRenderState.method_65581(thrownAxeEntity, thrownAxeEntity.method_54759(), this.itemModelManager);
    }

    @Override
    public void render(
            ThrownAxeEntityRenderState state,
            class_4587 matrices,
            class_11659 queue,
            class_12075 cameraState
    ) {
        matrices.method_22903();

        matrices.method_22905(1.5F, 1.5F, 1.5F);

        matrices.method_22907(class_7833.field_40715.rotationDegrees(90 - state.yaw));

        matrices.method_22907(class_7833.field_40718.rotationDegrees(state.pitch));

        matrices.method_46416(-0.15F, 0, 0);

        matrices.method_22907(class_7833.field_40717.rotationDegrees(state.spinDuration * 15));

        if (!state.rightFacing) {
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
        }

        class_916.method_56858(
                matrices,
                queue,
                state.field_61820,
                state,
                this.random
        );

        matrices.method_22909();

        super.method_3936(state, matrices, queue, cameraState);
    }
}
