package dev.mariany.improvedcombat.entity.custom;

import dev.mariany.improvedcombat.entity.ICEntityTypes;
import dev.mariany.improvedcombat.entity.damage.ICDamageTypes;
import dev.mariany.improvedcombat.sound.ICSoundEvents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9109;
import net.minecraft.class_9274;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.class_9710;
import net.minecraft.class_9721;
import net.minecraft.class_9725;

public class ThrownAxeEntity extends class_1665 {
    public static final String SLOT_KEY = "Slot";
    public static final String SPIN_DURATION_KEY = "SpinDuration";

    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(
            ThrownAxeEntity.class,
            class_2943.field_13319
    );
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(
            ThrownAxeEntity.class,
            class_2943.field_13322
    );

    private int slot;
    private long spinDuration;
    private boolean dealtDamage;
    private int returnTimer;

    public ThrownAxeEntity(class_1299<? extends ThrownAxeEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ThrownAxeEntity(class_1937 world, class_1309 owner, class_1799 stack, int slot) {
        super(ICEntityTypes.THROWN_AXE, owner, world, stack, null);
        this.slot = slot;
        this.syncEnchantData(stack);
    }

    public ThrownAxeEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(ICEntityTypes.THROWN_AXE, x, y, z, world, stack, null);
        this.syncEnchantData(stack);
    }

    private void syncEnchantData(class_1799 stack) {
        this.field_6011.method_12778(LOYALTY, getLoyalty(stack));
        this.field_6011.method_12778(ITEM, stack);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);

        builder.method_56912(LOYALTY, (byte) 0);
        builder.method_56912(ITEM, this.method_57314());
    }

    @Override
    protected class_3414 method_7440() {
        return ICSoundEvents.ITEM_AXE_HIT_GROUND;
    }

    @Override
    public void method_5773() {
        if (!this.method_24828() && this.field_7576 <= 0 && !this.field_5976 && !this.field_5992) {
            ++this.spinDuration;
        }

        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }

        if (this.method_20802() <= 1 && this.isFlameEnchanted()) {
            this.method_20803(5);
        }

        class_1297 entity = this.method_24921();
        int loyaltyLevel = this.field_6011.method_12789(LOYALTY);

        if (loyaltyLevel > 0 && (this.dealtDamage || this.method_7441()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (this.method_73183() instanceof class_3218 serverWorld &&
                        this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(serverWorld, this.method_7445(), 0.1F);
                }

                this.method_31472();
            } else {
                if (!(entity instanceof class_1657) &&
                        this.method_73189().method_1022(entity.method_33571()) < entity.method_17681() + 1) {
                    this.method_31472();
                    return;
                }

                this.method_7433(true);

                class_243 offset = entity.method_33571().method_1020(this.method_73189());
                this.method_23327(this.method_23317(), this.method_23318() + offset.field_1351 * 0.015 * loyaltyLevel, this.method_23321());

                double multiplier = 0.05 * loyaltyLevel;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(offset.method_1029().method_1021(multiplier)));

                if (this.returnTimer == 0) {
                    this.method_5783(ICSoundEvents.ITEM_AXE_RETURN, 10F, 1F);
                }

                this.returnTimer++;
            }
        }

        super.method_5773();
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        return entity != null && entity.method_5805() && (!(entity instanceof class_3222) || !entity.method_7325());
    }

    public boolean isEnchanted() {
        return this.field_6011.method_12789(ITEM).method_7958();
    }

    public long getSpinDuration() {
        return this.spinDuration;
    }

    private boolean isFlameEnchanted() {
        if (!this.method_54759().method_7960()) {
            class_9304 itemEnchantmentsComponent = this.method_54759().method_58694(
                    class_9334.field_49633
            );

            if (itemEnchantmentsComponent != null && !itemEnchantmentsComponent.method_57543()) {
                for (
                        Object2IntMap.Entry<class_6880<class_1887>> entry :
                        itemEnchantmentsComponent.method_57539()
                ) {
                    List<class_9710<class_9721>> postAttackEffects = entry.getKey().comp_349()
                                                                                                      .method_60034(
                                                                                                              class_9701.field_51665);

                    for (class_9710<class_9721> effect : postAttackEffects) {
                        if (effect.comp_2702() instanceof class_9725) {
                            return true;
                        }
                    }
                }
            }
        }

        return false;
    }

    @Override
    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        class_1297 victim = entityHitResult.method_17782();
        class_1297 owner = this.method_24921();
        class_1799 weapon = this.method_54759();

        MutableFloat damage = new MutableFloat(this.field_7571);

        weapon.method_60617(
                class_9274.field_49217,
                (entry, modifier, display) -> {
                    if (entry.equals(class_5134.field_23721)) {
                        damage.add(modifier.comp_2449());
                    }
                }
        );

        class_1282 damageSource = this.method_48923().method_48797(
                ICDamageTypes.THROWN_AXE,
                this,
                (owner == null ? this : owner)
        );

        if (this.method_73183() instanceof class_3218 serverWorld) {
            damage.setValue(class_1890.method_60120(serverWorld, weapon, victim, damageSource, damage.getValue()));
            damage.add(weapon.method_7909().method_58403(victim, damage.getValue(), damageSource));
        }

        this.dealtDamage = true;

        if (this.method_73183() instanceof class_3218 serverWorld) {
            class_1890.method_63016(
                    serverWorld,
                    victim,
                    damageSource,
                    this.method_54759(),
                    item -> this.method_5768(serverWorld)
            );
        }

        if (victim.method_64420(damageSource, damage.getValue())) {
            if (victim.method_5864() == class_1299.field_6091) {
                return;
            }

            if (victim instanceof class_1309 livingEntity) {
                this.method_59957(livingEntity, damageSource);
                this.method_7450(livingEntity);
            }
        }

        this.method_59859(class_9109.field_48348, victim, this.field_60558, false);
        this.method_18799(this.method_18798().method_18805(0.02, 0.2, 0.02));
        this.method_5783(ICSoundEvents.ITEM_AXE_HIT, 1F, 1F);
    }

    @Override
    protected void method_59957(class_1309 target, class_1282 source) {
        double multiplier = this.method_73183() instanceof class_3218 serverWorld
                ? class_1890.method_60175(serverWorld, this.method_54759(), target, source, 0.0F)
                : 0;

        if (multiplier > 0) {
            double resistance = Math.max(0, 1 - target.method_45325(class_5134.field_23718));
            class_243 knockback = this.method_18798()
                                  .method_18805(1, 0, 1)
                                  .method_1029()
                                  .method_1021(multiplier * 0.6 * resistance);

            if (knockback.method_1027() > 0) {
                target.method_5762(knockback.field_1352, 0.1, knockback.field_1350);
            }
        }
    }

    @Override
    public class_1799 method_54759() {
        return this.field_6011.method_12789(ITEM);
    }

    @Override
    protected void method_57313(class_1799 stack) {
        super.method_57313(stack);
        this.field_6011.method_12778(ITEM, super.method_54759());
    }

    @Override
    public class_1799 method_59958() {
        return this.method_54759();
    }

    @Override
    protected class_1799 method_57314() {
        return class_1802.field_8406.method_7854();
    }

    @Override
    protected void method_59956(
            class_3218 world, class_3965 blockHitResult,
            class_1799 weaponStack
    ) {
        class_243 vec3d = blockHitResult.method_17777().method_60913(blockHitResult.method_17784());
        class_1890.method_60124(
                world,
                weaponStack,
                this.method_24921() instanceof class_1309 livingEntity ? livingEntity : null,
                this,
                null,
                vec3d,
                world.method_8320(blockHitResult.method_17777()),
                item -> this.method_5768(world)
        );
    }

    @Override
    protected boolean method_34713(class_1657 player) {
        if (method_34714(player)) {
            class_1661 inventory = player.method_31548();

            if (inventory.method_5438(this.slot).method_7960()) {
                inventory.method_5447(this.slot, this.method_7445());
                return true;
            }
        }

        return super.method_34713(player) ||
                this.method_7441() && this.method_34714(player) && player.method_31548().method_7394(this.method_7445());
    }

    @Override
    public void method_5694(class_1657 player) {
        if (this.method_34714(player) || this.method_24921() == null) {
            super.method_5694(player);
        }
    }

    @Override
    public void method_7446() {
    }

    @Override
    protected void method_5825() {
        if (!this.method_7441() && this.method_5841().method_12789(LOYALTY) <= 0) {
            this.method_31472();
        } else {
            this.method_7433(true);
        }
    }

    private byte getLoyalty(class_1799 stack) {
        return this.method_73183() instanceof class_3218 serverWorld ?
                (byte) class_3532.method_15340(
                        class_1890.method_60169(serverWorld, stack, this),
                        0,
                        127
                ) : 0;
    }

    @Override
    protected void method_5749(class_11368 view) {
        super.method_5749(view);

        this.slot = view.method_71424(SLOT_KEY, 0);
        this.spinDuration = view.method_71425(SPIN_DURATION_KEY, 0);
    }

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);

        view.method_71465(SLOT_KEY, this.slot);
        view.method_71466(SPIN_DURATION_KEY, this.spinDuration);
    }
}
