package dev.mariany.improvedcombat.mixin;

import dev.mariany.improvedcombat.component.ICEnchantmentEffectComponentTypes;
import dev.mariany.improvedcombat.entity.custom.ThrownAxeEntity;
import dev.mariany.improvedcombat.sound.ICSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_9463;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_1743.class)
public class AxeItemMixin extends class_1792 implements class_9463 {
    public AxeItemMixin(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1676 method_58648(class_1937 world, class_2374 pos, class_1799 stack, class_2350 direction) {
        ThrownAxeEntity thrownAxeEntity = new ThrownAxeEntity(
                world,
                pos.method_10216(),
                pos.method_10214(),
                pos.method_10215(),
                stack.method_46651(1)
        );
        thrownAxeEntity.field_7572 = class_1665.class_1666.field_7593;
        return thrownAxeEntity;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);

        boolean canThrow = class_1890.method_60142(
                itemStack,
                ICEnchantmentEffectComponentTypes.ALLOW_AXE_THROW
        );

        if (!canThrow || itemStack.method_63692() || user.method_7261(0) < 1) {
            return class_1269.field_5814;
        }

        user.method_6019(hand);

        return class_1269.field_21466;
    }

    @Override
    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657 player) {
            int elapsedUseTicks = this.method_7881(stack, user) - remainingUseTicks;

            if (elapsedUseTicks < 5) {
                return false;
            }

            if (stack.method_63692()) {
                return false;
            }

            player.method_7259(class_3468.field_15372.method_14956(this));

            if (world instanceof class_3218 serverWorld) {
                stack.method_61653(1, player);
                class_1799 itemStack = stack.method_60504(1, player);

                ThrownAxeEntity thrownAxeEntity = class_1676.method_61549(
                        (spawnWorld, shooter, thrownStack) -> new ThrownAxeEntity(
                                spawnWorld,
                                shooter,
                                thrownStack,
                                getSelectedSlot(player)
                        ),
                        serverWorld,
                        itemStack,
                        player,
                        0F,
                        2.5F,
                        1F
                );

                if (player.method_56992()) {
                    thrownAxeEntity.field_7572 = class_1665.class_1666.field_7594;
                }

                world.method_43129(
                        null,
                        thrownAxeEntity,
                        ICSoundEvents.ITEM_AXE_THROW,
                        class_3419.field_15248,
                        1F,
                        1F
                );

                return true;
            }
        }

        return false;
    }

    @Unique
    private static int getSelectedSlot(class_1657 player) {
        if (player.method_6058().equals(class_1268.field_5810)) {
            return class_1661.field_30639;
        }

        return player.method_31548().method_67532();
    }
}
