package dev.mariany.improvedcombat.mixin;

import dev.mariany.improvedcombat.entity.ModifiableLivingEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1753.class)
public abstract class BowItemMixin extends class_1792 {
    @Shadow
    public abstract int method_7881(class_1799 stack, class_1309 user);

    public BowItemMixin(class_1793 settings) {
        super(settings);
    }

    @Inject(method = "use", at = @At(value = "RETURN"))
    public void injectOnUse(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (cir.getReturnValue().method_23665()) {
            class_1799 stack = user.method_5998(hand);
            int maxUseTime = method_7881(stack, user);
            int additionalTicks = getAdditionalTicks(stack, user, 1.1F);

            ((ModifiableLivingEntity) user).improvedcombat$setItemUseTimeLeft(maxUseTime - additionalTicks);
        }
    }

    @Unique
    private static int getAdditionalTicks(class_1799 stack, class_1309 user, float baseSeconds) {
        float chargeTime = class_1890.method_60159(stack, user, baseSeconds);
        return class_3532.method_15375((baseSeconds - chargeTime) * 20);
    }
}
